# OSPOS GTS – Step-by-Step cPanel Setup & Upgrade Guide

This guide walks you through **fresh installation** and **upgrading from stock OSPOS** on cPanel hosting.

---

## Table of Contents

1. [Before You Begin](#before-you-begin)
2. [Part A: Fresh Installation](#part-a-fresh-installation)
3. [Part B: Upgrade from Stock OSPOS](#part-b-upgrade-from-stock-ospos)
4. [Post-Install Checklist](#post-install-checklist)
5. [Troubleshooting](#troubleshooting)

---

## Before You Begin

### Requirements

| Requirement | Details |
|-------------|---------|
| **PHP** | 8.1 or higher |
| **MySQL / MariaDB** | 5.7+ or 10.3+ |
| **Extensions** | mysqli, mbstring, intl, json, xml, curl, zip, gd, bcmath, openssl |
| **Apache** | mod_rewrite enabled |

### Build the Production Package (on your computer)

1. Open a terminal/command prompt in the project folder.
2. Run:
   ```bash
   php build_package.php --optimize
   ```
3. Find the ZIP in the `dist/` folder (e.g. `ospos_gts-3.4.1-20250624.zip`).
4. You will upload this ZIP to cPanel.

> **Tip:** Use `--no-clean` if you want to skip cleaning cache (e.g. for testing):  
> `php build_package.php --optimize --no-clean`

---

## Part A: Fresh Installation

### Step 1: Create MySQL Database

1. Log in to **cPanel**.
2. Go to **Databases** → **MySQL® Databases**.
3. Under **Create New Database**:
   - Database name: `username_ospos` (replace `username` with your cPanel username).
   - Click **Create Database**.
4. Under **MySQL Users**:
   - Username: `username_dbuser`
   - Password: Create a strong password and save it.
   - Click **Create User**.
5. Under **Add User To Database**:
   - Select the user and the database.
   - Click **Add**.
   - On the privileges page, select **ALL PRIVILEGES** → **Make Changes**.
6. Note down:
   - Database name (e.g. `username_ospos`)
   - Username (e.g. `username_dbuser`)
   - Password
   - Host (usually `localhost`)

---

### Step 2: Upload and Extract Files

1. Go to **cPanel** → **Files** → **File Manager**.
2. Navigate to `public_html` (or the folder where your site lives).
3. Click **Upload**.
4. Upload the ZIP file from `dist/` (e.g. `ospos_gts-3.4.1-20250624.zip`).
5. After upload, right-click the ZIP → **Extract**.
6. Extract to a folder such as:
   - `public_html/ospos_gts/` for a subdomain or subfolder, **or**
   - `public_html/` if this is your main site (you may want to move contents into a subfolder first).
7. After extraction, you should see folders: `app`, `public`, `writable`, `vendor`, etc.

---

### Step 3: Set Document Root

Your web server must point to the `public` folder only. The rest of the app must stay outside the web root for security.

#### Option A: Addon Domain or Subdomain

1. Go to **cPanel** → **Domains** → **Addon Domains** (or **Subdomains**).
2. Create or edit the domain/subdomain.
3. Set **Document Root** to the `public` folder, e.g.:
   ```
   public_html/ospos_gts/public
   ```

#### Option B: Main Domain in Subfolder

1. Go to **Domains** → **Domains** (or **Addon Domains**).
2. Click **Manage** next to your domain.
3. Set **Document Root** to:
   ```
   public_html/ospos_gts/public
   ```

#### Option C: Subfolder as Main Site

If your site is at `https://yourdomain.com/ospos/`:

- Document root should be: `public_html/ospos/public`
- The app files go in `public_html/ospos/` (app, writable, vendor, etc.)

---

### Step 4: Create and Configure .env

1. In **File Manager**, go to your app root (e.g. `public_html/ospos_gts/`).
2. Find the file **.env.production**.
3. Right-click → **Copy**.
4. Rename the copy to **.env**.
5. Right-click **.env** → **Edit**.
6. Update these values:

   ```env
   CI_ENVIRONMENT = production
   CI_DEBUG = false

   app.baseURL = 'https://yourdomain.com/'
   # If in subfolder: app.baseURL = 'https://yourdomain.com/ospos/public/'

   database.default.hostname = localhost
   database.default.database = username_ospos
   database.default.username = username_dbuser
   database.default.password = your_password_here
   database.default.DBPrefix = ospos_
   ```

7. Save the file.

---

### Step 5: Generate Encryption Key

1. Go to **cPanel** → **Advanced** → **Terminal**.
2. Navigate to your app folder:
   ```bash
   cd ~/public_html/ospos_gts
   ```
3. Run:
   ```bash
   php spark key:generate
   ```
4. Copy the displayed key (64-character hex string).
5. Edit **.env** again and paste it:
   ```env
   encryption.key = YOUR_64_CHAR_HEX_KEY_HERE
   ```
6. Save.

> **Alternative (no Terminal):** If cPanel has **Setup PHP App** or **PHP Extensions**, ensure the CLI uses the same PHP version. Or use the one-time `public/generate_key.php` script (see [Troubleshooting](#generate-key-without-terminal)), then **delete it** after use.

---

### Step 6: Import Database

1. Go to **cPanel** → **Databases** → **phpMyAdmin**.
2. Select your database from the left.
3. Click the **Import** tab.
4. Click **Choose File** and select:  
   `app/Database/database.sql`  
   (from your extracted app folder, e.g. `public_html/ospos_gts/app/Database/database.sql`).
5. Click **Go** at the bottom.
6. Wait for the success message.

---

### Step 7: Set Writable Permissions

1. In **File Manager**, go to the `writable` folder.
2. Right-click `writable` → **Change Permissions**.
3. Set to **755** (or **775** if 755 does not work).
4. Enable **Recurse into subdirectories**.
5. Click **Change Permissions**.

Or in Terminal:
```bash
chmod -R 755 ~/public_html/ospos_gts/writable
```

---

### Step 8: Log In

1. Open your site in a browser (e.g. `https://yourdomain.com/` or `https://yourdomain.com/ospos/public/`).
2. Default credentials:
   - **Username:** `admin`
   - **Password:** `pointofsale`
3. Change the password immediately: **Configuration** → **Store Config** or your user profile.

---

## Part B: Upgrade from Stock OSPOS

Use this when you already have **stock OSPOS 3.2.x / 3.3.x / 3.4.x** and want to switch to OSPOS GTS without losing data.

### Step 1: Backup Everything

1. **cPanel** → **Databases** → **phpMyAdmin**.
2. Select your existing OSPOS database.
3. Click **Export** → **Quick** → **Go**.
4. Save the `.sql` file to your computer.
5. Also back up your current OSPOS files (e.g. via File Manager → Compress).

---

### Step 2: Create a Fresh Database (Recommended)

1. **Databases** → **MySQL® Databases**.
2. Create a new database (e.g. `username_ospos_new`).
3. Create a user or reuse an existing one.
4. Add the user to the new database with **ALL PRIVILEGES**.

---

### Step 3: Import Your OSPOS Data

1. Open **phpMyAdmin**.
2. Select the **new** database.
3. Click **Import**.
4. Choose the `.sql` file you exported from your stock OSPOS database.
5. Click **Go** and wait for completion.

---

### Step 4: Upload OSPOS GTS Files

1. **File Manager** → navigate to where you want the app (e.g. `public_html/`).
2. **Upload** the production ZIP from `dist/`.
3. **Extract** the ZIP.
4. If you had OSPOS in a folder like `public_html/ospos/`:
   - You can replace the old files by extracting into that folder (after backing up the old `uploads` folder).
   - Or extract to a new folder (e.g. `ospos_gts`) and update the document root.

---

### Step 5: Restore Uploads (If Replacing Old Install)

1. If you backed up the old OSPOS `uploads` folder, copy its contents into:
   ```
   public_html/ospos_gts/public/uploads/
   ```

---

### Step 6: Configure .env for Upgrade

1. Copy `.env.production` to `.env`.
2. Set database to your **imported** database:

   ```env
   CI_ENVIRONMENT = production
   CI_DEBUG = false

   app.baseURL = 'https://yourdomain.com/'

   database.default.hostname = localhost
   database.default.database = username_ospos_new
   database.default.username = username_dbuser
   database.default.password = your_password
   database.default.DBPrefix = ospos_
   ```

3. Generate a new encryption key: `php spark key:generate` (see [Step 5](#step-5-generate-encryption-key) above).

---

### Step 7: Set Document Root and Permissions

1. Set document root to `public/ospos_gts/public` (or your actual path).
2. Set `writable` to 755 (or 775).

---

### Step 8: Run Upgrade (Automatic)

1. Open your site in a browser.
2. Log in with your **existing OSPOS username and password**.
3. On first login, migrations run automatically. This may take 10–30 seconds.
4. Migrations will:
   - Adapt the database for CodeIgniter 4
   - Add `carton_qty`, `pieces_qty`, `sale_unit`
   - Add `item_unit`, `qty_per_carton`, etc. to items
   - Backfill carton/pieces from existing quantities
   - Update sessions and config
5. When complete, you can use the app as usual.

---

### Step 9: Verify After Upgrade

- Check **Sales** and **Receivings** – items and totals.
- Check **Items** – multi-unit fields (carton, box, etc.) if used.
- Check **Reports** – ensure data looks correct.

---

## Post-Install Checklist

| Task | Done |
|------|------|
| Change default admin password | ☐ |
| Set `CI_ENVIRONMENT = production` | ☐ |
| Set `CI_DEBUG = false` | ☐ |
| Document root points to `public/` | ☐ |
| `.env` is outside document root | ☐ |
| New `encryption.key` generated for production | ☐ |
| HTTPS enabled (recommended) | ☐ |
| Remove `public/health_check.php` if used | ☐ |
| Remove `public/generate_key.php` if used | ☐ |

---

## Troubleshooting

### "We seem to have hit a snag"

1. Temporarily set `CI_DEBUG = true` in `.env` to see the error.
2. Check `writable/logs/log-YYYY-MM-DD.log`.
3. Upload `public/health_check.php` (from a dev copy) and open it in the browser to verify PHP/database. **Delete it after use.**

### CSS/JS Not Loading

- Ensure `app.baseURL` in `.env` exactly matches your site URL, e.g.:
  - Root: `https://yourdomain.com/`
  - Subfolder: `https://yourdomain.com/ospos/public/`

### Database Connection Failed

- Use `localhost` as host (most cPanel setups).
- Confirm database name, username, and password.
- Ensure the user has full privileges on the database.

### Writable Permission Errors

```bash
chmod -R 755 writable
```

On some hosts you may need 775. Contact support if it still fails.

### Generate Key Without Terminal

1. Upload `public/generate_key.php` from the dev package.
2. Open `https://yourdomain.com/generate_key.php` in a browser.
3. Copy the key into `.env`.
4. **Delete `generate_key.php` immediately** for security.

### Migration Errors on Upgrade

- Restore your database backup.
- Ensure source DB is from OSPOS 3.2.0 or newer.
- Run migrations manually via Terminal: `php spark migrate`
- Check `writable/logs/` for details.

---

## More Information

- **Full deployment reference:** [DEPLOYMENT.md](DEPLOYMENT.md)
- **General install:** [INSTALL.md](INSTALL.md)
- **Local development:** [README.md](README.md)
