# OSPOS GTS – Production Deployment Guide

Production deployment guide for **cPanel** and other shared hosts. Covers fresh installs, production hardening, and upgrading from stock Open Source Point of Sale (OSPOS).

---

## Table of Contents

1. [Build Production Package](#build-production-package)
2. [Requirements](#requirements)
3. [cPanel Deployment](#cpanel-deployment)
4. [Production Checklist](#production-checklist)
5. [Upgrading from Stock OSPOS](#upgrading-from-stock-ospos)
6. [Compact Deployment (Optional)](#compact-deployment-optional)
7. [Troubleshooting](#troubleshooting)

---

## Build Production Package

Before deploying, create a production ZIP:

```bash
php build_package.php --optimize
```

The ZIP is created in `dist/` (e.g. `dist/ospos_gts-3.4.1-20250624.zip`). Upload this file to your hosting.

**See [CPANEL_SETUP.md](CPANEL_SETUP.md) for a step-by-step cPanel setup and upgrade tutorial.**

---

## Requirements

- **PHP** 8.1 or higher
- **MySQL** 5.7+ or MariaDB 10.3+
- **Extensions**: mysqli, mbstring, intl, json, xml, curl, zip
- **mod_rewrite** enabled (Apache)

---

## cPanel Deployment

### 1. Upload Files

Upload the entire project to your hosting account (e.g. `/home/username/ospos_gts/`).

### 2. Set Document Root

In cPanel → **Domains** or **Addon Domains** → **Document Root**:

- Set document root to: `public_html/ospos_gts/public`  
  (or `public/ospos_gts/public` if the app lives in a subfolder)

**Important:** Only the `public/` folder should be web-accessible. `app/`, `writable/`, `.env`, etc. must stay outside the document root.

### 3. Create MySQL Database

1. cPanel → **MySQL Databases**
2. Create database (e.g. `username_ospos`)
3. Create user and assign ALL PRIVILEGES to the database
4. Note hostname (usually `localhost`), database name, username, password

### 4. Configure Environment

Copy `.env.production` to `.env` in the project root:

```bash
cp .env.production .env
```

Edit `.env`:

```env
CI_ENVIRONMENT = production
CI_DEBUG = false

# Required – use your full URL
app.baseURL = 'https://yourdomain.com/'
# If in subfolder: app.baseURL = 'https://yourdomain.com/ospos/public/'

database.default.hostname = localhost
database.default.database = username_ospos
database.default.username = username_dbuser
database.default.password = your_secure_password
database.default.DBPrefix = ospos_

logger.threshold = 4
```

### 5. Generate Encryption Key

From the project root (SSH or cPanel Terminal):

```bash
php spark key:generate
```

Copy the output into `.env`:

```env
encryption.key = YOUR_GENERATED_64_CHAR_HEX_KEY
```

**Never** copy the development encryption key to production.

### 6. Import Database (Fresh Install)

**Option A – cPanel phpMyAdmin**

1. Open phpMyAdmin
2. Select your database
3. **Import** → Choose `app/Database/database.sql` → Go

**Option B – SSH**

```bash
mysql -u username_dbuser -p username_ospos < app/Database/database.sql
```

### 7. Set Writable Permissions

Ensure the web server can write to:

- `writable/logs/`
- `writable/cache/`
- `writable/session/`
- `writable/uploads/`
- `writable/backups/`

Via cPanel File Manager or SSH:

```bash
chmod -R 755 writable
# Or, if needed: chmod -R 775 writable
```

### 8. Secure `.env`

Confirm `.env` is **not** in the document root and is not directly accessible via the web. The `public/` folder should not contain `.env`.

---

## Production Checklist

| Step | Status |
|------|--------|
| Set `CI_ENVIRONMENT = production` | ☐ |
| Set `CI_DEBUG = false` | ☐ |
| Set `app.baseURL` to full URL | ☐ |
| Generate new `encryption.key` | ☐ |
| Database credentials correct | ☐ |
| `writable/` subdirectories writable | ☐ |
| Document root = `public/` | ☐ |
| Remove `public/health_check.php` after use | ☐ |
| Remove `public/generate_key.php` after use | ☐ |
| HTTPS configured (recommended) | ☐ |

---

## Upgrading from Stock OSPOS

This app can upgrade a database from **stock OSPOS 3.2.x / 3.3.x / 3.4.x** without data loss.

### Prerequisites

1. **Backup your database**
2. Stock OSPOS 3.2.0 or newer

### Upgrade Steps

1. **Export your stock OSPOS database** (full dump).

2. **Create a new database** on your hosting (or use a copy of the existing one).

3. **Import the dump** into this new database.

4. **Point OSPOS GTS to the imported database** in `.env`:

   ```env
   database.default.database = your_ospos_database
   database.default.DBPrefix = ospos_
   ```

5. **Upload OSPOS GTS files** and set document root to `public/` as described above.

6. **Log in** to the app. On first login, migrations run automatically and:

   - Convert CI3 schema to CI4 (sessions, app_config, etc.)
   - Add carton/pieces columns to `sales_items` and `receivings_items`
   - Add multi-unit support (item_unit, qty_per_carton, etc.)
   - Apply any other pending migrations

7. **Verify** sales, receivings, items, and reports.

### What Migrations Do

- Add `carton_qty`, `pieces_qty`, `sale_unit` where missing
- Add `item_unit`, `qty_per_carton`, `qty_per_box`, etc. to items
- Backfill carton/pieces from existing `quantity_purchased` using item units
- Add config keys for custom payment methods, default price type, etc.
- Update sessions table structure for CI4

### Schema Compatibility

Migrations check for existing columns/tables before altering them. If a column exists, it is skipped, so running migrations more than once is safe.

---

## Compact Deployment (Optional)

To reduce size for upload or hosting limits:

### Files/Folders to Remove Before Upload

- `docker-compose*.yml`, `Dockerfile` (if you don’t use Docker)
- `writable/debugbar/` (clear before deploy)
- `public/health_check.php` (after troubleshooting)
- `public/generate_key.php` (after generating key)
- `tests/` (if present)
- `docs/` (optional)
- Extra markdown: `BUILD.md`, `CHANGELOG.md`, etc. (optional)

### Run Prepare Script (optional)

```bash
php prepare_deploy.php
```

This cleans debugbar, creates a `.deployignore`, and shows a pre-deploy checklist.

### Vendor Size

`vendor/` is required. To shrink it, you can run:

```bash
composer install --no-dev --optimize-autoloader
```

---

## Troubleshooting

### "We seem to have hit a snag"

1. Upload `public/health_check.php` and open it in the browser. **Delete it after use.**
2. Temporarily set `CI_DEBUG = true` in `.env` to see the error.
3. Check `writable/logs/log-YYYY-MM-DD.log`.

### CSS/JS Not Loading

Set `app.baseURL` in `.env` to your full URL, e.g.:

```env
app.baseURL = 'https://yourdomain.com/'
```

For subfolder installs:

```env
app.baseURL = 'https://yourdomain.com/ospos/public/'
```

### Database Connection Failed

- Confirm host (often `localhost` on cPanel)
- Confirm database name, user, and password
- Ensure the user has privileges on the database

### Writable Permission Errors

```bash
chmod -R 755 writable
chown -R www-data:www-data writable   # Linux – user may differ on cPanel
```

### Migration Errors on Upgrade

- Restore a backup of the database.
- Ensure the source DB is from OSPOS 3.2.0+.
- Run migrations manually: `php spark migrate`
- Check `writable/logs/` for details.

---

## Re-export Database

To regenerate `database.sql` from a running database:

```bash
mysqldump -u user -p database_name --single-transaction --default-character-set=utf8mb4 > app/Database/database.sql
```

Or use **Config → Database** in the OSPOS admin panel to create a backup.
