<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_add_receive_payment_flag extends Migration
{
    /**
     * Add is_receive_payment flag to distinguish payments made via Receive Payment
     * (customer page) from payments made at the sales register.
     */
    public function up(): void
    {
        $this->db->query('ALTER TABLE ' . $this->db->prefixTable('sales_payments')
            . ' ADD COLUMN `is_receive_payment` tinyint(1) NOT NULL DEFAULT 0 AFTER `cash_adjustment`');
    }

    /**
     * Revert the migration.
     */
    public function down(): void
    {
        $this->db->query('ALTER TABLE ' . $this->db->prefixTable('sales_payments')
            . ' DROP COLUMN `is_receive_payment`');
    }
}
