<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_add_receivings_payments extends Migration
{
    /**
     * Create receivings_payments table for Make Payment (supplier credit purchase payments).
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix();
        $this->db->query("CREATE TABLE IF NOT EXISTS `{$prefix}receivings_payments` (
            `payment_id` int(11) NOT NULL AUTO_INCREMENT,
            `receiving_id` int(10) NOT NULL,
            `payment_type` varchar(40) NOT NULL,
            `payment_amount` decimal(15,2) NOT NULL,
            `employee_id` int(11) DEFAULT NULL,
            `payment_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`payment_id`),
            KEY `receiving_id` (`receiving_id`),
            CONSTRAINT `receivings_payments_ibfk_1` FOREIGN KEY (`receiving_id`) REFERENCES `{$prefix}receivings` (`receiving_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
    }

    /**
     * Revert the migration.
     */
    public function down(): void
    {
        $this->db->query('DROP TABLE IF EXISTS ' . $this->db->prefixTable('receivings_payments'));
    }
}
