<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_add_custom_payment_methods_config extends Migration
{
    /**
     * Add custom_payment_methods config key for user-defined payment methods.
     */
    public function up(): void
    {
        $this->db->table('app_config')->ignore(true)->insert([
            'key'   => 'custom_payment_methods',
            'value' => '[]'
        ]);
        cache()->delete('settings');
    }

    /**
     * Revert migration.
     */
    public function down(): void
    {
        $this->db->table('app_config')->where('key', 'custom_payment_methods')->delete();
    }
}
