<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_add_default_sale_price_type_config extends Migration
{
    /**
     * Add default_sale_price_type config for Retail/Wholesale price selection.
     */
    public function up(): void
    {
        $this->db->table('app_config')->ignore(true)->insert([
            'key'   => 'default_sale_price_type',
            'value' => 'retail'
        ]);
        cache()->delete('settings');
    }

    /**
     * Revert migration.
     */
    public function down(): void
    {
        $this->db->table('app_config')->where('key', 'default_sale_price_type')->delete();
    }
}
