<?php

namespace App\Libraries;

use CodeIgniter\Database\BaseConnection;

/**
 * Adapter for report-related database schema detection.
 * Centralizes logic for handling different column names across schema versions.
 */
class Report_schema
{
    public function __construct(
        private readonly BaseConnection $db
    ) {
    }

    /**
     * Get the quantity column name for sales_items (quantity, quantity_purchased, or qty).
     * Checks actual table columns via fieldExists; OSPOS standard uses quantity_purchased.
     *
     * @return string Column name to use in queries
     */
    public function getSalesItemsQuantityColumn(): string
    {
        $tableName  = $this->db->prefixTable('sales_items');
        $candidates = ['quantity_purchased', 'quantity', 'qty'];

        foreach ($candidates as $candidate) {
            if ($this->db->fieldExists($candidate, $tableName)) {
                return $candidate;
            }
        }

        return 'quantity_purchased';
    }

    /**
     * Check if sales_items has discount column.
     */
    public function salesItemsHasDiscount(): bool
    {
        return $this->db->fieldExists('discount', $this->db->prefixTable('sales_items'));
    }
}
