<?php

namespace App\Models\Reports;

class Summary_items extends Summary_report
{
    /**
     * @return array[]
     */
    protected function _get_data_columns(): array    // TODO: Hungarian notation
    {
        return [
            ['item_name'  => lang('Reports.item')],
            ['category'   => lang('Reports.category')],
            ['cost_price' => lang('Reports.cost_price'), 'sorter' => 'number_sorter'],
            ['unit_price' => lang('Reports.unit_price'), 'sorter' => 'number_sorter'],
            ['carton_qty' => lang('Sales.carton_qty')],
            ['pieces_qty' => lang('Sales.pieces_qty')],
            ['subtotal'   => lang('Reports.subtotal'), 'sorter' => 'number_sorter'],
            ['tax'        => lang('Reports.tax'), 'sorter' => 'number_sorter'],
            ['total'      => lang('Reports.total'), 'sorter' => 'number_sorter'],
            ['cost'       => lang('Reports.cost'), 'sorter' => 'number_sorter'],
            ['profit'     => lang('Reports.profit'), 'sorter' => 'number_sorter']
        ];
    }

    /**
     * @param array $inputs
     * @param object $builder
     * @return void
     */
    protected function _select(array $inputs, object &$builder): void    // TODO: hungarian notation
    {
        parent::_select($inputs, $builder);    // TODO: hungarian notation

        $cartonFields = '';
        if ($this->db->fieldExists('item_unit', $this->db->getPrefix() . 'items')) {
            $cartonFields = ', MAX(items.item_unit) AS item_unit, MAX(items.qty_per_unit) AS qty_per_unit, MAX(items.qty_per_carton) AS qty_per_carton, MAX(items.qty_per_box) AS qty_per_box, MAX(items.qty_per_bag) AS qty_per_bag, MAX(items.qty_per_pack) AS qty_per_pack, MAX(items.pack_name) AS pack_name';
        }
        $cartonPieces = $this->db->fieldExists('carton_qty', $this->db->getPrefix() . 'sales_items')
            ? ', SUM(COALESCE(sales_items.carton_qty, 0)) AS carton_qty, SUM(COALESCE(sales_items.pieces_qty, 0)) AS pieces_qty'
            : ', 0 AS carton_qty, 0 AS pieces_qty';
        $builder->select('
                MAX(items.name) AS name,
                MAX(items.category) AS category,
                MAX(items.cost_price) AS cost_price,
                MAX(items.unit_price) AS unit_price,
                SUM(sales_items.quantity_purchased) AS quantity_purchased' . $cartonPieces . '
                ' . $cartonFields . '
        ');
    }

    /**
     * @param object $builder
     * @return void
     */
    protected function _from(object &$builder): void    // TODO: hungarian notation
    {
        parent::_from($builder);

        $builder->join('items AS items', 'sales_items.item_id = items.item_id', 'inner');
    }

    /**
     * @param object $builder
     * @return void
     */
    protected function _group_order(object &$builder): void    // TODO: hungarian notation
    {
        $builder->groupBy('items.item_id');
        $builder->orderBy('name');
    }
}
