<?php
/**
 * @var array $payment_methods
 */
?>

<?= form_open('config/savePaymentMethods/', ['id' => 'payment_methods_config_form', 'class' => 'form-horizontal']) ?>
    <div id="config_wrapper">
        <fieldset id="config_info">
            <div class="help-block"><?= lang('Config.payment_methods_help') ?></div>
            <ul id="payment_methods_error_message_box" class="error_message_box"></ul>

            <div id="payment_methods_list">
                <?= view('partial/payment_methods', ['payment_methods' => $payment_methods]) ?>
            </div>

            <?= form_submit([
                'name'  => 'submit_payment_methods',
                'id'    => 'submit_payment_methods',
                'value' => lang('Common.submit'),
                'class' => 'btn btn-primary btn-sm pull-right'
            ]) ?>
        </fieldset>
    </div>
<?= form_close() ?>

<script type="text/javascript">
$(document).ready(function() {
    var payment_method_count = <?= count($payment_methods ?: ['']) ?>;

    var hide_show_remove = function() {
        if ($(".payment_method_row").length > 1) {
            $(".remove_payment_method").show();
        } else {
            $(".remove_payment_method").hide();
        }
    };

    var add_payment_method = function() {
        var block = $(this).closest('.payment_method_row').clone(true);
        block.find('input').val('');
        block.find('label').attr('for', 'payment_method_' + (++payment_method_count)).html("<?= esc(lang('Config.payment_method'), 'js') ?> " + payment_method_count);
        block.find('input').attr('id', 'payment_method_' + payment_method_count);
        $(this).closest('.payment_method_row').after(block);
        hide_show_remove();
    };

    var remove_payment_method = function() {
        $(this).closest('.payment_method_row').remove();
        hide_show_remove();
    };

    $(document).on('click', '.add_payment_method', add_payment_method);
    $(document).on('click', '.remove_payment_method', remove_payment_method);
    hide_show_remove();

    $('#payment_methods_config_form').ajaxForm({
        success: function(response) {
            $.notify({
                message: response.message
            }, {
                type: response.success ? 'success' : 'danger'
            });
            if (response.success) {
                $('#payment_methods_list').load('<?= base_url('config/paymentMethods') ?>', hide_show_remove);
            }
        },
        dataType: 'json'
    });
});
</script>
