<?php
/**
 * @var string $supplier_name
 * @var \CodeIgniter\Database\ResultInterface $payments
 * @var array $config
 */
?>

<?= view('partial/header') ?>

<div id="title_bar" class="btn-toolbar">
    <?= anchor('suppliers', '<span class="glyphicon glyphicon-arrow-left">&nbsp;</span>' . lang('Common.back'), ['class' => 'btn btn-info btn-sm']) ?>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Suppliers.total_credit_paid') ?> - <?= esc($supplier_name) ?></h3>
    </div>
    <div class="panel-body">
        <?php if ($payments->getNumRows() === 0): ?>
            <p><?= lang('Suppliers.no_payments') ?></p>
        <?php else: ?>
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th><?= lang('Common.date') ?></th>
                        <th><?= lang('Common.id') ?></th>
                        <th><?= lang('Sales.payment_type') ?></th>
                        <th><?= lang('Sales.payment_amount') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($payments->getResult() as $payment): ?>
                        <tr>
                            <td><?= to_datetime(strtotime($payment->payment_time)) ?></td>
                            <td><?= anchor('receivings/receipt/' . $payment->receiving_id, 'RECV ' . $payment->receiving_id, ['target' => '_blank', 'title' => lang('Receivings.receipt_number')]) ?></td>
                            <td><?= esc($payment->payment_type) ?></td>
                            <td><?= to_currency($payment->amount) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?= view('partial/footer') ?>
