# Production Deployment Guide

## Pre-deployment Checklist

- [ ] Database exported to `app/Database/database.sql` ✓
- [ ] `.env.production` template created ✓
- [ ] `writable/` directory writable by web server (logs, cache, session, uploads, backups)
- [ ] `public/` set as document root (or adjust paths)

## Deployment Steps

### 1. Switch to Production Environment

Copy production settings to `.env` or update:

```env
CI_ENVIRONMENT = production
CI_DEBUG = false
logger.threshold = 4
```

### 2. Configure Database

Set database credentials in `.env` (or use environment variables):

```env
database.default.hostname = your-db-host
database.default.database = ospos_gts
database.default.username = your-db-user
database.default.password = your-db-password
```

### 3. Generate Encryption Key

**Important:** Generate a new encryption key for production:

```bash
php spark key:generate
```

Copy the generated key into `.env` under `encryption.key`.

### 4. Import Database (if fresh install)

```bash
mysql -u user -p database_name < app/Database/database.sql
```

### 5. Set Permissions

Ensure the web server can write to:
- `writable/logs/`
- `writable/cache/`
- `writable/session/`
- `writable/uploads/`
- `writable/backups/`

### 6. Secure `.env`

Ensure `.env` is not accessible from the web. The `public/` folder should be the only web-accessible directory.

### 7. Enable HTTPS

Configure your web server for HTTPS. Update `app/Config/Filters.php` if using ForceHTTPS.

## Re-export Database

To recreate `database.sql` from the current database:

```bash
# Windows (XAMPP)
C:\xampp\mysql\bin\mysqldump.exe -h localhost -u root -p ospos_gts_new --single-transaction --default-character-set=utf8mb4 --result-file=app\Database\database.sql

# Linux/macOS
mysqldump -h localhost -u root -p ospos_gts_new --single-transaction --default-character-set=utf8mb4 > app/Database/database.sql
```

Or use the built-in backup from **Config → Database** in the OSPOS admin panel.

## Troubleshooting "We seem to have hit a snag" on Live Server

When the app works locally but shows a generic error on live:

1. **Run the health check** – Upload `public/health_check.php` and visit `https://yourdomain.com/health_check.php`. It will show which checks fail. **Delete the file after use.**

2. **See the actual error** – Temporarily set in `.env`:
   ```env
   CI_DEBUG = true
   ```
   Refresh the page to see the real error. Set back to `false` when done.

3. **Check the log** – Ensure `logger.threshold = 4` in `.env`. Then check `writable/logs/log-YYYY-MM-DD.log` for the error details.

4. **Common causes**:
   - **Database** – Host, database name, user, or password in `.env` do not match the live MySQL
   - **encryption.key** – Must be generated on the live server with `php spark key:generate`, not copied from local
   - **Writable permissions** – Run `chmod -R 755 writable` (or 775 depending on server)
   - **baseURL** – If installed in a subfolder, add `app.baseURL = 'https://yourdomain.com/path/public/'` to `.env`
   - **CSS/JS not loading** – Set `app.baseURL` in `.env` to your full site URL (e.g. `https://yourdomain.com/`). Required when behind a proxy or when auto-detection fails.
