# OSPOS GTS Complete User Guide

This guide covers all features of the Open Source Point of Sale (OSPOS) GTS system from login through reports and configuration.

---

## Table of Contents

1. [Introduction](#1-introduction)
2. [Login](#2-login)
3. [Home Dashboard](#3-home-dashboard)
4. [Sales (Point of Sale)](#4-sales-point-of-sale)
5. [Receivings (Purchase Orders)](#5-receivings-purchase-orders)
6. [Branch Transfers](#6-branch-transfers)
7. [Items (Product Catalog)](#7-items-product-catalog)
8. [Item Kits](#8-item-kits)
9. [Gift Cards](#9-gift-cards)
10. [Attributes](#10-attributes)
11. [Customers](#11-customers)
12. [Suppliers](#12-suppliers)
13. [Employees](#13-employees)
14. [Reports](#14-reports)
15. [Cashups](#15-cashups)
16. [Expenses](#16-expenses)
17. [Expense Categories](#17-expense-categories)
18. [Taxes](#18-taxes)
19. [Messages](#19-messages)
20. [Configuration](#20-configuration)
21. [Office vs Home](#21-office-vs-home)

---

## 1. Introduction

OSPOS GTS is a point-of-sale system that supports:

- **Sales** – Retail sales, returns, quotes, invoices, and work orders
- **Receivings** – Purchase orders, receiving stock from suppliers
- **Transfers** – Moving inventory between branches/locations
- **Inventory** – Items, item kits, attributes, gift cards
- **People** – Customers, suppliers, employees
- **Finance** – Reports, cashups, expenses
- **Configuration** – System settings, tax, receipt, invoice options

Access to modules depends on your user permissions.

---

## 2. Login

### How to Log In

1. Open the application URL in your browser.
2. Enter your **Username** in the first field.
3. Enter your **Password** in the second field.
4. Click **Go** (or the login button).
5. If credentials are correct, you are redirected to **Home** (or **Office** if configured).

### Notes

- If Google reCAPTCHA is enabled, complete the captcha before logging in.
- If a database migration is required, an alert will appear and migrations will run after login.
- Invalid credentials show an error message.

### Top Bar

- **Clock** – Current date and time
- **Home / Office** – Switch between Home and Office dashboards (if enabled)
- **Company name** – Displayed in the center
- **Your name** – Opens change-password dialog
- **Logout** – Log out of the system

---

## 3. Home Dashboard

The Home screen summarizes business activity.

### Summaries Section

 - **Today / This Week / This Month** – Total sales and transaction count
- **Credit Sales** – Outstanding customer receivables (link to Debtors report)
- **Credit Purchase** – Outstanding supplier payables (link to Creditors report)
- **Receivings** – Purchase orders count (today / week / month)
- **Items Received** – Quantity received (today / week / month)
- **Transfers** – Transfer count between locations
- **Expenses** – Total expenses (today / week / month)
- **Low Inventory** – Number of items below reorder level
- **Expiring Soon** – Items near or past expiry
- **Average Sale** – Average transaction value

### Charts

- **Sales Trend** – Last 7 days bar chart
- **Sales vs Expenses** – Pie chart comparison

### Analysis

- **Today vs Yesterday** – Percentage change
- **Week vs Last Week** – Percentage change
- **Month vs Last Month** – Percentage change

### Recommendations

- Links to low-inventory or expiring items when relevant

### Quick Access

- Module shortcuts for Sales, Items, Customers, Reports, etc.

---

## 4. Sales (Point of Sale)

Sales is the main cash register / POS.

### Access Sales

Click **Sales** in the menu.

### Modes (Transaction Types)

Select the mode from the dropdown at the top:

| Mode        | Description                                  |
|-------------|----------------------------------------------|
| **Sale**    | Normal retail sale                           |
| **Return**  | Return items to inventory                    |
| **Quote**   | Create quotation for a customer               |
| **Invoice** | Create an invoice                            |
| **Work Order** | Create a work order                      |

### Finding or Adding Items

1. In **Find or Scan Item or Receipt**, type:
   - Item name
   - Barcode / item number
   - Or scan with a barcode scanner
2. Press **Enter** or use the search to add the item.
3. **Unit**: Choose **Auto** (default) or **Piece** for selling units.

### Optional: Customer

- Click **Customer** or use the customer search.
- Required for credit sales.
- Customer discount, if set, is applied automatically.

### Optional: Table

If **Dinner Tables** are enabled in configuration:

- Select a table from the dropdown.
- Useful for restaurants or table-based sales.

### Optional: Stock Location

If there are multiple stock locations:

- Select which location the sale is from.

### Adding Items Manually

- Use the **New Item** button to add a one-off item while in the register.
- Use the Item Number / Name / Description fields to edit line items.
- Use **Delete** (trash icon) to remove a line.
- Adjust **Quantity**, **Price**, **Discount**, and **Total** as needed.

### Completing the Sale

1. Add all items and verify the cart.
2. Click **Complete** (or Complete Sale).
3. Add payment:
   - **Cash** – Enter amount tendered; change is calculated.
   - **Check** – Enter check number and amount.
   - **Credit Card / Debit Card** – Enter amount.
4. For split payments, use **Add Payment** for each method.
5. When **Payments Cover Total**, click **Complete** to finalize.

### After Sale Options

- **Print Receipt** – Print after completion (if enabled).
- **Email Receipt** – Email receipt to customer.
- **Comment** – Add a note to the sale.
- **Invoice Number** – Set custom invoice number (if allowed).

### Suspend / Resume Sales

- **Suspend** – Save the current cart for later (e.g. for layaway).
- **Suspended Sales** – List suspended sales; choose one to resume.

### Manage Sales (Takings)

- Click **Takings** to open **Manage Sales**.
- View, filter, and search completed sales.
- Actions:
  - **Edit** – Change sale details.
  - **Delete** – Void and remove.
  - **Restore** – Undo a deleted sale.
  - **Receipt** – Reprint receipt.
  - **Invoice** – View or print invoice.
  - **Send PDF** – Email invoice.
  - **Send Receipt** – Email receipt.

---

## 5. Receivings (Purchase Orders)

Receivings handles stock received from suppliers.

### Access Receivings

Click **Receivings** in the menu.

### Modes

| Mode        | Description                                |
|-------------|--------------------------------------------|
| **Receive** | Standard receiving from supplier           |
| **Requisition** | Internal requisition (no supplier)    |

### Adding Items

1. Use **Find or Scan Item** or scan barcodes.
2. Add quantity and optional price; cost updates automatically.
3. Use **Stock Item Search** to pick items from inventory.

### Supplier

- For **Receive** mode, select a **Supplier**.
- Supplier can be required or optional depending on configuration.

### Reference

- Optional reference number for the receiving (e.g. PO number).

### Completing

1. Add all received items.
2. Add a comment if needed.
3. Click **Complete** to finalize the receiving.
4. Inventory is updated for the selected source location.

### Manage Receivings

- Use **Manage** to list all receivings.
- **Edit** – Modify a receiving.
- **Delete** – Remove and optionally reverse inventory.
- **Receipt** – Print receiving receipt.

---

## 6. Branch Transfers

Use this module to move stock between locations.

### Access Transfers

Click **Branch Transfers** (or **Transfers**) in the menu.

### Creating a Transfer

1. Click **Transfer** (or **Add**).
2. Select **From Branch** (source) and **To Branch** (destination).
3. Add items:
   - Search by name or barcode.
   - Enter quantity to transfer.
4. Add optional **Comment**.
5. Click **Submit** (or **Complete**) to process.

### Viewing Transfers

- The list shows Transfer ID, From Branch, To Branch, Date, Employee.
- Click **Details** on a transfer to see full information.

### Notes

- Both source and destination locations must exist.
- Transfers reduce stock at source and increase it at destination.

---

## 7. Items (Product Catalog)

### Access Items

Click **Items** in the menu.

### Managing Items

- **Search** – Filter by name, barcode, category, or other criteria.
- **Filters** – Out of Stock, Low Inventory, Expired/Near Expire, etc.
- **Stock Location** – Filter by location.
- **Date Range** – Filter by added/updated date.

### Adding a New Item

1. Click **New Item** (or **+**).
2. Enter:
   - **Item Number (Barcode)** – Unique identifier
   - **Item Name**
   - **Category**
   - **Wholesale Price** (cost)
   - **Retail Price** (selling price)
   - **Quantity** (starting inventory)
   - **Reorder Level** – Low-stock threshold
   - **Location** – Default stock location
3. Optional:
   - **Description**
   - **Image**
   - **Expire Date**
   - **Serial Number** (for serialized items)
4. Click **Submit** to save.

### Editing Items

- Click **Edit** on a row.
- Update fields and save.

### Bulk Edit

1. Select multiple items with the checkboxes.
2. Click **Bulk Edit**.
3. Change only the fields you want.
4. Save to update all selected items.

### Inventory

- **Update Inventory** – Adjust quantity (add/subtract).
- **Count Details** – See inventory change history.
- **Received Batches** – View received batches (for expiry tracking).

### Generate Barcodes

1. Select one or more items.
2. Click **Generate Barcodes**.
3. A new window opens with printable barcodes.

### Attributes

- Assign attributes (e.g. size, color) from the item form.
- See [Attributes](#10-attributes) section.

### Deleting Items

- Select items and click **Delete**.
- Items with sales history cannot be deleted; you can mark them deleted instead.

---

## 8. Item Kits

Item kits are bundles of multiple items sold as one product.

### Access Item Kits

Click **Item Kits** in the menu.

### Creating a Kit

1. Click **New Item Kit**.
2. Enter:
   - **Kit Name**
   - **Kit Number** (identifier)
3. Add items:
   - Search and add each item.
   - Set quantity per item in the kit.
4. Save.

### Using Kits in Sales

- Search for the kit by name or kit number in the register.
- Adding a kit adds all included items with their quantities and prices.

---

## 9. Gift Cards

### Access Gift Cards

Click **Gift Cards** in the menu.

### Adding Gift Cards

1. Click **New Gift Card**.
2. Enter:
   - **Gift Card Number** – Unique ID (or generate)
   - **Value** – Initial balance
3. Save.

### Using Gift Cards

- At the register, add the gift card as payment.
- Enter the gift card number and amount to apply.
- Balance is reduced automatically.

### Managing Gift Cards

- Search and filter gift cards.
- View balance and usage.
- Edit or delete as needed.

---

## 10. Attributes

Attributes (e.g. Size, Color) let you define options for items.

### Access Attributes

Click **Attributes** in the menu.

### Creating Attributes

1. Click **New Attribute**.
2. Enter attribute name (e.g. Size, Color).
3. Add attribute values (e.g. S, M, L or Red, Blue).
4. Save.

### Assigning to Items

- Open an item for edit.
- Use the **Attributes** section to link attributes and values.
- Items can have multiple attributes.

---

## 11. Customers

### Access Customers

Click **Customers** in the menu.

### Adding a Customer

1. Click **New Customer**.
2. Enter:
   - **First Name**, **Last Name**
   - **Email**
   - **Phone**
   - **Address**
   - **Account Number** (optional)
   - **Discount** (optional)
3. Save.

### Customer Actions

- **Sales** – View sales history for the customer.
- **Credit Sales** – View credit (unpaid) sales.
- **Payments** – View payments made.
- **Receive Payment** – Record a payment against credit balance.

### Receive Payment

1. Open the customer.
2. Click **Receive Payment**.
3. Enter amount and payment type.
4. Submit to reduce their balance.

### CSV Import

- Use **Import CSV** to bulk import customers.
- Match CSV columns to system fields as prompted.

### Deleting Customers

- Select and click **Delete**.
- Customers with sales may have restrictions.

---

## 12. Suppliers

### Access Suppliers

Click **Suppliers** in the menu.

### Adding a Supplier

1. Click **New Supplier**.
2. Enter company name, contact, email, phone, address.
3. Save.

### Supplier Actions

- **Receivings** – View receivings from this supplier.
- **Credit Receivings** – View unpaid receivings.
- **Payments** – View payments to supplier.
- **Receive Payment** – Record a payment (credit to your account with supplier).

### Deleting Suppliers

- Select and click **Delete**.

---

## 13. Employees

### Access Employees

Click **Employees** in the menu.

### Adding an Employee

1. Click **New Employee**.
2. Enter:
   - **First Name**, **Last Name**
   - **Email**, **Phone**
   - **Username** – For login
   - **Password**
   - **Permissions** – Grant access to modules
3. Save.

### Permissions

- Modules: Sales, Receivings, Items, Customers, Reports, Config, etc.
- Grant only what each employee needs.

### Change Password

- Click your name in the top bar.
- Use **Change Password** to update your password.
- Requires current password.

---

## 14. Reports

### Access Reports

Click **Reports** in the menu.

Reports are grouped as:

- **Graphical Reports** – Charts
- **Summary Reports** – Tabular summaries
- **Detailed Reports** – Transaction-level details
- **Inventory Reports** – Stock-related
- **Debtors & Creditors** – Customer and supplier balances

### Report Types

#### Graphical Reports

- **Summary Sales** – Sales by date range, type, location
- **Summary Items** – Items sold
- **Summary Categories** – Sales by category
- **Summary Customers** – Customer sales
- **Summary Suppliers** – Supplier receivings
- **Summary Employees** – Employee sales
- **Summary Taxes** – Tax collected
- **Summary Discounts** – Discounts given
- **Summary Payments** – Payment methods
- **Summary Expense Categories** – Expenses by category

#### Summary Reports

Same reports as above in tabular format.

#### Detailed Reports

- **Detailed Sales** – Each sale with items and payments
- **Detailed Receivings** – Each receiving with items
- **Detailed Transfers** – Each transfer with items

#### Specific Reports

- **Specific Customer** – Sales for one customer
- **Specific Employee** – Sales for one employee
- **Specific Supplier** – Receivings for one supplier
- **Specific Discounts** – Discounts by type

#### Inventory Reports

- **Expired / Near Expire** – Items expiring within X days
- **Low Inventory** – Items below reorder level
- **Inventory Summary** – Stock by location

#### Debtors & Creditors

- **Debtors Report** – Customers with outstanding balance
- **Creditors Report** – Suppliers with outstanding balance

### Running a Report

1. Click the report link.
2. Select **Date Range** (and other filters if shown).
3. Choose **Sale Type** (All, Sales, Returns, etc.) if applicable.
4. Choose **Location** if multi-location.
5. Click **Generate** or equivalent.

### Report Options

- **Tabular** – Table view
- **Graphical** – Chart view (where available)
- Export – Use browser print or export if enabled

---

## 15. Cashups

Cashups manage daily cash register close-outs.

### Access Cashups

Click **Cashups** in the menu.

### Opening a Cashup (Day Start)

1. Click **New Cashup** (or Open Register).
2. Enter opening cash amount.
3. Save.

### Closing a Cashup (Day End)

1. Open the current cashup.
2. Enter closing cash count.
3. Add cash adjustments (deposits, withdrawals) if needed.
4. Save to close.

### Viewing Cashups

- List shows open/close times, amounts, and differences.
- Useful for reconciling cash and tracking discrepancies.

---

## 16. Expenses

### Access Expenses

Click **Expenses** in the menu.

### Adding an Expense

1. Click **New Expense**.
2. Enter:
   - **Date**
   - **Amount**
   - **Expense Category**
   - **Description**
3. Save.

### Managing Expenses

- Search and filter by date, category, amount.
- Edit or delete expenses.

---

## 17. Expense Categories

### Access Expense Categories

Click **Expense Categories** in the menu.

### Managing Categories

- Add categories (e.g. Rent, Utilities, Supplies).
- Edit or delete categories.
- Categories are used when recording expenses and in expense reports.

---

## 18. Taxes

### Access Taxes

Click **Taxes** in the menu (under Finance).

### Tax Configuration

- **Tax Categories** – Define tax groups.
- **Tax Rates** – Set percentage and apply to categories.
- **Tax Jurisdictions** – For location-based taxes.
- **Tax Codes** – Optional tax codes.

### Applying Taxes to Items

- Assign a tax category to each item.
- Taxes are calculated automatically in sales based on configuration.

---

## 19. Messages

### Access Messages

Click **Messages** in the menu.

### Sending SMS

1. Enter **Phone number(s)** – Use comma separation for multiple numbers.
2. Enter your **Message** in the text area.
3. Click **Submit** to send.

*Note: SMS sending requires SMS gateway configuration. Contact your administrator for setup.*

---

## 20. Configuration

### Access Configuration

Click **Configuration** (or **Config**) in the menu.

### Configuration Tabs

#### Info

- **Company Name**
- **Company Logo**
- **Address**
- **Phone**
- **Website**
- **Email**

#### General

- **Default Sale Type**
- **Default Payment Type**
- **Receipt**
- **Invoice** options

#### Tax

- Tax rates and categories.
- Tax display and calculation options.

#### Locale

- **Time Zone**
- **Date Format**
- **Time Format**
- **Currency**
- **Number Format** (decimals, thousands separator)

#### Barcode

- Barcode format and generation settings.

#### Stock (Location)

- **Stock Locations** – Add, edit, delete locations.
- Default locations for sales and receivings.

#### Receipt

- Receipt header/footer text.
- Print options.
- Receipt printer settings.

#### Invoice

- Invoice layout.
- Invoice number format.
- Logo and company info on invoice.

#### Reward

- Customer rewards / loyalty points (if enabled).
- Point values and redemption rules.

#### Dinner Tables

- Enable/disable table management.
- Create and manage tables (for restaurants).

#### System (with sub-tabs)

- **System** – General system information.
- **Database** – **Backup Database** (create a backup), **Reset** (reset specific features or full database – use with caution).
- **Email** – SMTP settings for sending emails (receipts, invoices).
- **Message** – SMS/message configuration.
- **Integrations** – **MailChimp** (API key and list for customer marketing).
- **License** – Software license information.

---

## 21. Office vs Home

Some setups use two dashboards:

- **Home** – Standard dashboard with sales-focused summaries.
- **Office** – Same layout but for office/back-office use.

Use the **Home** / **Office** link in the top bar to switch.

---

## Quick Reference

| Task              | Path                               |
|-------------------|------------------------------------|
| Log in            | Login page                         |
| New sale          | Sales → Add items → Complete       |
| New receiving     | Receivings → Add items → Complete  |
| New transfer      | Transfers → Transfer               |
| New item          | Items → New Item                   |
| New customer      | Customers → New Customer           |
| New supplier      | Suppliers → New Supplier           |
| Reports           | Reports → Choose report            |
| Change settings   | Configuration → Tab                |
| Change password   | Your name (top bar) → Change Password |

---

## Support

For issues or feature requests, refer to the OSPOS project documentation or your system administrator.
