<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->setDefaultController('Login');

$routes->get('/', 'Login::index');
$routes->get('login', 'Login::index');
$routes->post('login', 'Login::index');

$routes->add('no_access/index/(:segment)', 'No_access::index/$1');
$routes->add('no_access/index/(:segment)/(:segment)', 'No_access::index/$1/$2');
$routes->add('no_access/(:segment)/(:segment)', 'No_access::index/$1/$2');

$routes->add('reports/summary_transfers/(:any)/(:any)/(:any)/(:any)/(:any)', 'Reports::detailed_transfers/$1/$2/$3/$4');
$routes->add('reports/summary_transfers/(:any)/(:any)/(:any)/(:any)', 'Reports::detailed_transfers/$1/$2/$3/$4');
$routes->add('reports/summary_transfers', 'Reports::date_input_transfers');
$routes->add('reports/summary_(:any)/(:any)/(:any)/(:any)/(:any)', 'Reports::Summary_$1/$2/$3/$4/$5');
$routes->add('reports/summary_(:any)/(:any)/(:any)', 'Reports::Summary_$1/$2/$3/$4');
$routes->add('reports/summary_expenses_categories', 'Reports::date_input_only');
$routes->add('reports/summary_payments', 'Reports::date_input_only');
$routes->add('reports/summary_discounts', 'Reports::summary_discounts_input');
$routes->add('reports/summary_(:any)', 'Reports::date_input');

$routes->add('reports/graphical_summary_transfers/(:any)/(:any)/(:any)/(:any)/(:any)', 'Reports::detailed_transfers/$1/$2/$3/$4');
$routes->add('reports/graphical_summary_transfers/(:any)/(:any)/(:any)/(:any)', 'Reports::detailed_transfers/$1/$2/$3/$4');
$routes->add('reports/graphical_summary_transfers', 'Reports::date_input_transfers');
$routes->add('reports/graphical_(:any)/(:any)/(:any)', 'Reports::Graphical_$1/$2/$3/$4');
$routes->add('reports/graphical_summary_expenses_categories', 'Reports::date_input_only');
$routes->add('reports/graphical_summary_discounts', 'Reports::summary_discounts_input');
$routes->add('reports/graphical_(:any)', 'Reports::date_input');

$routes->add('reports/inventory_(:any)/(:any)', 'Reports::Inventory_$1/$2');
$routes->add('reports/inventory_expired', 'Reports::inventory_expired_input');
$routes->add('reports/inventory_expired/(:any)/(:any)', 'Reports::inventory_expired/$1/$2');
$routes->add('reports/inventory_low', 'Reports::inventory_low');
$routes->add('reports/inventory_summary', 'Reports::inventory_summary_input');
$routes->add('reports/inventory_summary/(:any)/(:any)/(:any)', 'Reports::inventory_summary/$1/$2/$3');

$routes->add('reports/detailed_(:any)/(:any)/(:any)/(:any)', 'Reports::Detailed_$1/$2/$3/$4');
$routes->add('reports/detailed_sales', 'Reports::date_input_sales');
$routes->add('reports/detailed_receivings', 'Reports::date_input_recv');
$routes->add('reports/detailed_transfers', 'Reports::date_input_transfers');

$routes->add('reports/specific_(:any)/(:any)/(:any)/(:any)', 'Reports::Specific_$1/$2/$3/$4');
$routes->add('reports/specific_customers', 'Reports::specific_customer_input');
$routes->add('reports/specific_employees', 'Reports::specific_employee_input');
$routes->add('reports/specific_discounts', 'Reports::specific_discount_input');
$routes->add('reports/specific_suppliers', 'Reports::specific_supplier_input');
