<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Sell_by_unit extends Migration
{
    /**
     * Add support for selling products in Carton, Box, Pack, and Pieces.
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $itemsTable = $prefix . 'items';
        $salesItemsTable = $prefix . 'sales_items';
        $suspendedTable = $prefix . 'sales_suspended_items';

        if ($this->db->tableExists($itemsTable) && !$this->db->fieldExists('qty_per_box', $itemsTable)) {
            $this->db->query("ALTER TABLE `{$itemsTable}` ADD COLUMN `qty_per_box` decimal(15,3) NOT NULL DEFAULT 0");
        }
        if ($this->db->tableExists($itemsTable) && !$this->db->fieldExists('qty_per_carton', $itemsTable)) {
            $this->db->query("ALTER TABLE `{$itemsTable}` ADD COLUMN `qty_per_carton` decimal(15,3) NOT NULL DEFAULT 0");
        }
        if ($this->db->tableExists($itemsTable) && !$this->db->fieldExists('qty_per_bag', $itemsTable)) {
            $this->db->query("ALTER TABLE `{$itemsTable}` ADD COLUMN `qty_per_bag` decimal(15,3) NOT NULL DEFAULT 0");
        }
        if ($this->db->tableExists($itemsTable) && !$this->db->fieldExists('item_unit', $itemsTable)) {
            $this->db->query("ALTER TABLE `{$itemsTable}` ADD COLUMN `item_unit` varchar(20) NOT NULL DEFAULT 'piece'");
        }
        if ($this->db->tableExists($itemsTable) && !$this->db->fieldExists('qty_per_unit', $itemsTable)) {
            $this->db->query("ALTER TABLE `{$itemsTable}` ADD COLUMN `qty_per_unit` decimal(15,3) NOT NULL DEFAULT 1");
            $this->db->query("UPDATE `{$itemsTable}` SET item_unit = 'carton', qty_per_unit = qty_per_carton WHERE qty_per_carton > 0");
            $this->db->query("UPDATE `{$itemsTable}` SET item_unit = 'box', qty_per_unit = qty_per_box WHERE qty_per_box > 0 AND item_unit = 'piece'");
            $this->db->query("UPDATE `{$itemsTable}` SET item_unit = 'pack', qty_per_unit = qty_per_pack WHERE qty_per_pack > 0 AND item_unit = 'piece'");
            $this->db->query("UPDATE `{$itemsTable}` SET item_unit = 'bag', qty_per_unit = qty_per_bag WHERE qty_per_bag > 0 AND item_unit = 'piece'");
        }

        if ($this->db->tableExists($salesItemsTable) && !$this->db->fieldExists('sale_unit', $salesItemsTable)) {
            $this->db->query("ALTER TABLE `{$salesItemsTable}` ADD COLUMN `sale_unit` varchar(20) NOT NULL DEFAULT 'piece'");
        }

        if ($this->db->tableExists($suspendedTable) && !$this->db->fieldExists('sale_unit', $suspendedTable)) {
            $this->db->query("ALTER TABLE `{$suspendedTable}` ADD COLUMN `sale_unit` varchar(20) NOT NULL DEFAULT 'piece'");
        }
    }

    public function down(): void
    {
        $prefix = $this->db->getPrefix();

        if ($this->db->fieldExists('item_unit', $prefix . 'items')) {
            $this->db->query("ALTER TABLE `{$prefix}items` DROP COLUMN `item_unit`");
        }
        if ($this->db->fieldExists('qty_per_unit', $prefix . 'items')) {
            $this->db->query("ALTER TABLE `{$prefix}items` DROP COLUMN `qty_per_unit`");
        }
        if ($this->db->fieldExists('qty_per_box', $prefix . 'items')) {
            $this->db->query("ALTER TABLE `{$prefix}items`
                DROP COLUMN `qty_per_box`,
                DROP COLUMN `qty_per_carton`");
        }
        if ($this->db->fieldExists('qty_per_bag', $prefix . 'items')) {
            $this->db->query("ALTER TABLE `{$prefix}items` DROP COLUMN `qty_per_bag`");
        }

        if ($this->db->fieldExists('sale_unit', $prefix . 'sales_items')) {
            $this->db->query("ALTER TABLE `{$prefix}sales_items` DROP COLUMN `sale_unit`");
        }

        if ($this->db->tableExists($prefix . 'sales_suspended_items') && $this->db->fieldExists('sale_unit', $prefix . 'sales_suspended_items')) {
            $this->db->query("ALTER TABLE `{$prefix}sales_suspended_items` DROP COLUMN `sale_unit`");
        }
    }
}
