<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Item_expire_date extends Migration
{
    /**
     * Add expire_date column to items table for product expiration tracking.
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $itemsTable = $prefix . 'items';

        if ($this->db->tableExists($itemsTable) && !$this->db->fieldExists('expire_date', $itemsTable)) {
            $this->db->query("ALTER TABLE `{$itemsTable}` ADD COLUMN `expire_date` date DEFAULT NULL");
        }
    }

    public function down(): void
    {
        $prefix = $this->db->getPrefix();

        if ($this->db->fieldExists('expire_date', $prefix . 'items')) {
            $this->db->query("ALTER TABLE `{$prefix}items` DROP COLUMN `expire_date`");
        }
    }
}
