<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_add_expire_date_to_receivings_items extends Migration
{
    /**
     * Add expire_date to receivings_items for batch-level expiration tracking.
     * Enables capturing different expire dates when receiving the same item in different batches
     * (e.g. RENZO 750 batch 1: 09/30/2026, batch 2: 11/30/2027).
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $table = $prefix . 'receivings_items';

        if ($this->db->tableExists($table) && !$this->db->fieldExists('expire_date', $table)) {
            $this->db->query("ALTER TABLE `{$table}` ADD COLUMN `expire_date` date DEFAULT NULL AFTER `item_location`");
        }
    }

    public function down(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $table = $prefix . 'receivings_items';

        if ($this->db->fieldExists('expire_date', $table)) {
            $this->db->query("ALTER TABLE `{$table}` DROP COLUMN `expire_date`");
        }
    }
}
