<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_reports_transfers_permission extends Migration
{
    /**
     * Add reports_transfers permission and grant to users who have transfers.
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix();
        $grantsTable = $prefix . 'grants';

        if ($this->db->table($prefix . 'permissions')->where('permission_id', 'reports_transfers')->countAllResults() === 0) {
            $this->db->query("INSERT INTO `{$prefix}permissions` (`permission_id`, `module_id`) VALUES ('reports_transfers', 'reports')");
        }

        if ($this->db->table($grantsTable)->where('permission_id', 'reports_transfers')->countAllResults() > 0) {
            return;
        }

        $peopleWithTransfers = $this->db->table($grantsTable)->select('person_id')->where('permission_id', 'transfers')->get()->getResultArray();
        $personIds = empty($peopleWithTransfers) ? [1] : array_unique(array_column($peopleWithTransfers, 'person_id'));
        foreach ($personIds as $pid) {
            $pid = (int) $pid;
            $this->db->table($grantsTable)->insert(['permission_id' => 'reports_transfers', 'person_id' => $pid]);
        }
    }

    public function down(): void
    {
        $prefix = $this->db->getPrefix();
        $this->db->table($prefix . 'grants')->where('permission_id', 'reports_transfers')->delete();
        $this->db->table($prefix . 'permissions')->where('permission_id', 'reports_transfers')->delete();
    }
}
