<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_price_precision_no_rounding extends Migration
{
    /**
     * Increase item_cost_price and item_unit_price precision to avoid rounding.
     * Ensures receiving cost and sales prices remain exact until explicitly changed.
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix() ?: '';

        if ($this->db->tableExists($prefix . 'receivings_items')) {
            $table = $prefix . 'receivings_items';
            if ($this->db->fieldExists('item_cost_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `item_cost_price` decimal(15,6) NOT NULL");
            }
        }

        if ($this->db->tableExists($prefix . 'sales_items')) {
            $table = $prefix . 'sales_items';
            if ($this->db->fieldExists('item_unit_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `item_unit_price` decimal(15,6) NOT NULL");
            }
            if ($this->db->fieldExists('item_cost_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `item_cost_price` decimal(15,6) NOT NULL");
            }
        }
    }

    public function down(): void
    {
        $prefix = $this->db->getPrefix() ?: '';

        if ($this->db->tableExists($prefix . 'receivings_items')) {
            $table = $prefix . 'receivings_items';
            if ($this->db->fieldExists('item_cost_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `item_cost_price` decimal(15,2) NOT NULL");
            }
        }

        if ($this->db->tableExists($prefix . 'sales_items')) {
            $table = $prefix . 'sales_items';
            if ($this->db->fieldExists('item_unit_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `item_unit_price` decimal(15,2) NOT NULL");
            }
            if ($this->db->fieldExists('item_cost_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `item_cost_price` decimal(15,2) NOT NULL");
            }
        }
    }
}
