<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_items_price_cost_precision extends Migration
{
    /**
     * Increase items.cost_price and items.unit_price precision to decimal(15,6)
     * so values entered by user are preserved without rounding after save.
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $table = $prefix . 'items';

        if ($this->db->tableExists($table)) {
            if ($this->db->fieldExists('cost_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `cost_price` decimal(15,6) NOT NULL");
            }
            if ($this->db->fieldExists('unit_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `unit_price` decimal(15,6) NOT NULL");
            }
        }
    }

    public function down(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $table = $prefix . 'items';

        if ($this->db->tableExists($table)) {
            if ($this->db->fieldExists('cost_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `cost_price` decimal(15,2) NOT NULL");
            }
            if ($this->db->fieldExists('unit_price', $table)) {
                $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `unit_price` decimal(15,2) NOT NULL");
            }
        }
    }
}
