<?php

namespace App\Models\Reports;

use App\Models\Item;

/**
 *
 *
 * @property item item
 *
 */
class Inventory_low extends Report
{
    /**
     * @return array[]
     */
    public function getDataColumns(): array
    {
        $cols = [
            ['item_name'     => lang('Reports.item_name')],
            ['item_number'   => lang('Reports.item_number')],
            ['quantity'      => lang('Reports.quantity')],
            ['carton_qty'    => lang('Sales.carton_qty')],
            ['pieces_qty'    => lang('Sales.pieces_qty')],
            ['reorder_level' => lang('Reports.reorder_level')],
            ['location_name' => lang('Reports.stock_location')]
        ];
        if ($this->db->fieldExists('expire_date', $this->db->getPrefix() . 'items')) {
            $cols[] = ['expire_date' => lang('Items.expire_date')];
        }
        return $cols;
    }

    /**
     * @param array $inputs
     * @return array
     */
    public function getData(array $inputs): array
    {    // TODO: convert to using QueryBuilder. Use App/Models/Reports/Summary_taxes.php getData() as a reference template
        $item = model(Item::class);
        $expire_col = $this->db->fieldExists('expire_date', $this->db->getPrefix() . 'items')
            ? ', items.expire_date' : '';
        $itemCols = $this->db->fieldExists('item_unit', $this->db->getPrefix() . 'items')
            ? ', items.item_unit, items.qty_per_unit, items.qty_per_carton, items.qty_per_box, items.qty_per_bag, items.qty_per_pack, items.pack_name'
            : '';
        $query = $this->db->query("SELECT " . $item->get_item_name('name') . ",
            items.item_number,
            item_quantities.quantity,
            items.reorder_level,
            stock_locations.location_name" . $itemCols . $expire_col . "
            FROM " . $this->db->prefixTable('items') . " AS items
            JOIN " . $this->db->prefixTable('item_quantities') . " AS item_quantities ON items.item_id = item_quantities.item_id
            JOIN " . $this->db->prefixTable('stock_locations') . " AS stock_locations ON item_quantities.location_id = stock_locations.location_id
            WHERE items.deleted = 0
            AND items.stock_type = 0
            AND item_quantities.quantity <= items.reorder_level
            AND stock_locations.deleted = 0
            ORDER BY items.name");

        return $query->getResultArray() ?: [];
    }

    /**
     * @param array $inputs
     * @return array
     */
    public function getSummaryData(array $inputs): array
    {
        return [];
    }
}
