<?php

namespace App\Models\Reports;

class Summary_customers extends Summary_report
{
    /**
     * @return array[]
     */
    protected function _get_data_columns(): array    // TODO: Hungarian notation
    {
        return [
            ['customer_name' => lang('Reports.customer')],
            ['sales'         => lang('Reports.sales'), 'sorter' => 'number_sorter'],
            ['quantity'      => lang('Reports.quantity'), 'sorter' => 'number_sorter'],
            ['subtotal'      => lang('Reports.subtotal'), 'sorter' => 'number_sorter'],
            ['tax'           => lang('Reports.tax'), 'sorter' => 'number_sorter'],
            ['total'         => lang('Reports.total'), 'sorter' => 'number_sorter'],
            ['amount_due'    => lang('Sales.amount_due'), 'sorter' => 'number_sorter'],
            ['cost'          => lang('Reports.cost'), 'sorter' => 'number_sorter'],
            ['profit'        => lang('Reports.profit'), 'sorter' => 'number_sorter']
        ];
    }

    /**
     * @param array $inputs
     * @param object $builder
     * @return void
     */
    protected function _select(array $inputs, object &$builder): void    // TODO: Hungarian notation
    {
        parent::_select($inputs, $builder);    // TODO: Hungarian notation

        $builder->select('
                MAX(CONCAT(customer_p.first_name, " ", customer_p.last_name)) AS customer,
                SUM(sales_items.quantity_purchased) AS quantity_purchased,
                COUNT(DISTINCT sales.sale_id) AS sales,
                IFNULL(MAX(customer_sales_balance_temp.total_amount_due), 0) AS amount_due
        ');
    }

    /**
     * @param object $builder
     * @return void
     */
    protected function _from(object &$builder): void    // TODO: Hungarian notation
    {
        parent::_from($builder);    // TODO: Hungarian notation

        $builder->join('people AS customer_p', 'sales.customer_id = customer_p.person_id');
        $builder->join(
            'customer_sales_balance_temp AS customer_sales_balance_temp',
            'sales.customer_id = customer_sales_balance_temp.customer_id',
            'left'
        );
    }

    /**
     * @param object $builder
     * @return void
     */
    protected function _group_order(object &$builder): void    // TODO: Hungarian notation
    {
        $builder->groupBy('sales.customer_id');
        $builder->orderBy('customer_p.last_name');
    }

    /**
     * @param array $inputs
     * @return array
     */
    public function getSummaryData(array $inputs): array
    {
        $summary = parent::getSummaryData($inputs);
        $balance = $this->db->table('customer_sales_balance_temp')
            ->selectSum('total_amount_due')
            ->get()
            ->getRow();
        $summary['amount_due'] = $balance?->total_amount_due ?? 0;

        return $summary;
    }
}
