<?php
/**
 * @var string $controller_name
 * @var array $reset_features
 * @var bool $backup_available
 */

$controller = $controller_name ?? 'config';
$tokenName = config('Security')->tokenName ?? 'csrf_test_name';
?>
<div class="panel panel-default">
<?= csrf_field() ?>
    <div class="panel-heading">
        <h4 class="panel-title"><?= lang('Config.database_options') ?></h4>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <h5><?= lang('Config.backup_database') ?></h5>
            <p class="help-block"><?= lang('Config.backup_database_desc') ?></p>
            <?php if ($backup_available) : ?>
                <button type="button" class="btn btn-primary" id="db_backup_btn">
                    <span class="glyphicon glyphicon-save-file"></span> <?= lang('Config.backup_button') ?>
                </button>
                <span id="backup_status" class="text-muted" style="margin-left: 10px;"></span>
            <?php else : ?>
                <p class="text-warning"><?= lang('Config.backup_not_available') ?></p>
            <?php endif; ?>
        </div>

        <hr>

        <div class="form-group">
            <h5><?= lang('Config.reset_feature') ?></h5>
            <p class="help-block"><?= lang('Config.reset_feature_desc') ?></p>
            <div class="row">
                <div class="col-sm-4">
                    <select id="reset_feature_select" class="form-control input-sm">
                        <option value=""><?= lang('Config.select_feature') ?></option>
                        <?php foreach ($reset_features as $id => $info) : ?>
                            <option value="<?= esc($id) ?>"><?= esc($info['label']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-sm-2">
                    <button type="button" class="btn btn-warning btn-sm" id="db_reset_feature_btn" disabled>
                        <span class="glyphicon glyphicon-trash"></span> <?= lang('Config.reset_feature') ?>
                    </button>
                </div>
            </div>
            <span id="reset_feature_status" class="text-muted" style="margin-left: 0;"></span>
        </div>

        <hr>

        <div class="form-group">
            <h5><?= lang('Config.reset_all_data') ?></h5>
            <p class="help-block text-danger"><?= lang('Config.reset_all_data_desc') ?></p>
            <button type="button" class="btn btn-danger" id="db_reset_all_btn">
                <span class="glyphicon glyphicon-alert"></span> <?= lang('Config.reset_all_data') ?>
            </button>
            <span id="reset_all_status" class="text-muted" style="margin-left: 10px;"></span>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    $('#reset_feature_select').on('change', function() {
        $('#db_reset_feature_btn').prop('disabled', !$(this).val());
    });

    $('#db_backup_btn').on('click', function() {
        var btn = $(this);
        btn.prop('disabled', true);
        $('#backup_status').text('<?= esc(lang('Config.backup_in_progress'), 'js') ?>');
        $.post('<?= site_url("$controller/backupDatabase") ?>', {
            '<?= esc($tokenName, 'js') ?>': $('#database_tabs input[name="<?= esc($tokenName, 'js') ?>"]').val()
        }, function(resp) {
            var data = typeof resp === 'object' ? resp : JSON.parse(resp);
            if (data.success && data.download_url) {
                $('#backup_status').html('<a href="' + data.download_url + '" target="_blank"><?= esc(lang('Config.backup_download'), 'js') ?></a>');
            } else {
                $('#backup_status').text(data.message || '<?= esc(lang('Config.backup_failed'), 'js') ?>').addClass('text-danger');
            }
        }, 'json').fail(function() {
            $('#backup_status').text('<?= esc(lang('Config.backup_failed'), 'js') ?>').addClass('text-danger');
        }).always(function() {
            btn.prop('disabled', false);
        });
    });

    $('#db_reset_feature_btn').on('click', function() {
        var feature = $('#reset_feature_select').val();
        if (!feature || !confirm('<?= esc(lang('Config.reset_feature_confirm'), 'js') ?>')) return;
        var btn = $(this);
        btn.prop('disabled', true);
        $('#reset_feature_status').text('...').removeClass('text-danger text-success');
        $.post('<?= site_url("$controller/resetDatabaseFeature") ?>', {
            feature: feature,
            '<?= esc($tokenName, 'js') ?>': $('#database_tabs input[name="<?= esc($tokenName, 'js') ?>"]').val()
        }, function(resp) {
            var data = typeof resp === 'object' ? resp : JSON.parse(resp);
            $('#reset_feature_status').text(data.message || '').addClass(data.success ? 'text-success' : 'text-danger');
        }, 'json').fail(function() {
            $('#reset_feature_status').text('<?= esc(lang('Common.error'), 'js') ?>').addClass('text-danger');
        }).always(function() {
            btn.prop('disabled', false);
        });
    });

    $('#db_reset_all_btn').on('click', function() {
        if (!confirm('<?= esc(lang('Config.reset_all_confirm'), 'js') ?>')) return;
        var btn = $(this);
        btn.prop('disabled', true);
        $('#reset_all_status').text('...').removeClass('text-danger text-success');
        $.post('<?= site_url("$controller/resetAllDatabase") ?>', {
            '<?= esc($tokenName, 'js') ?>': $('#database_tabs input[name="<?= esc($tokenName, 'js') ?>"]').val()
        }, function(resp) {
            var data = typeof resp === 'object' ? resp : JSON.parse(resp);
            $('#reset_all_status').text(data.message || '').addClass(data.success ? 'text-success' : 'text-danger');
            if (data.success) setTimeout(function() { location.reload(); }, 1500);
        }, 'json').fail(function() {
            $('#reset_all_status').text('<?= esc(lang('Common.error'), 'js') ?>').addClass('text-danger');
        }).always(function() {
            btn.prop('disabled', false);
        });
    });
});
</script>
