<?php
/**
 * @var string $customer_name
 * @var array $credit_sales
 * @var array $config
 */
?>

<?= view('partial/header') ?>

<div id="title_bar" class="btn-toolbar">
    <?= anchor('customers', '<span class="glyphicon glyphicon-arrow-left">&nbsp;</span>' . lang('Common.back'), ['class' => 'btn btn-info btn-sm']) ?>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Customers.total_credit') ?> - <?= esc($customer_name) ?></h3>
    </div>
    <div class="panel-body">
        <?php if (empty($credit_sales)): ?>
            <p><?= lang('Customers.no_credit_sales') ?></p>
        <?php else: ?>
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th><?= lang('Common.id') ?></th>
                        <th><?= lang('Sales.sale_time') ?></th>
                        <th><?= lang('Sales.amount_due') ?></th>
                        <th><?= lang('Sales.amount_tendered') ?></th>
                        <th><?= lang('Customers.credit_balance') ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($credit_sales as $sale): ?>
                        <tr>
                            <td><?= esc($sale->sale_id) ?></td>
                            <td><?= to_datetime(strtotime($sale->sale_time)) ?></td>
                            <td><?= to_currency($sale->total) ?></td>
                            <td><?= to_currency($sale->paid) ?></td>
                            <td><?= to_currency($sale->balance) ?></td>
                            <td><?= anchor('sales/receipt/' . $sale->sale_id, '<span class="glyphicon glyphicon-usd"></span>', ['title' => lang('Sales.show_receipt')]) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?= view('partial/footer') ?>
