<?php
/**
 * @var int $customer_id
 * @var string $customer_name
 * @var float $credit_balance
 * @var array $payment_options
 * @var array $config
 */
?>

<div id="required_fields_message"><?= lang('Common.fields_required_message') ?></div>
<ul id="error_message_box" class="error_message_box"></ul>

<?= form_open('customers/receive_payment', ['id' => 'receive_payment_form', 'class' => 'form-horizontal']) ?>
    <?= form_hidden('customer_id', (string) $customer_id) ?>
    <fieldset id="receive_payment_info">

        <div class="form-group form-group-sm">
            <?= form_label(lang('Customers.customer'), 'customer_name', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?= form_input([
                    'name'  => 'customer_name',
                    'id'    => 'customer_name',
                    'class' => 'form-control input-sm',
                    'value' => $customer_name,
                    'readonly' => 'readonly'
                ]) ?>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Customers.credit_balance'), 'credit_balance', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-4">
                <div class="input-group input-group-sm">
                    <?php if (!is_right_side_currency_symbol()): ?>
                        <span class="input-group-addon input-sm"><?= esc($config['currency_symbol']) ?></span>
                    <?php endif; ?>
                    <?= form_input([
                        'name'  => 'credit_balance_display',
                        'id'    => 'credit_balance_display',
                        'class' => 'form-control input-sm',
                        'value' => to_currency_no_money($credit_balance),
                        'readonly' => 'readonly'
                    ]) ?>
                    <?php if (is_right_side_currency_symbol()): ?>
                        <span class="input-group-addon input-sm"><?= esc($config['currency_symbol']) ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Sales.payment_amount'), 'payment_amount', ['class' => 'required control-label col-xs-3']) ?>
            <div class="col-xs-4">
                <div class="input-group input-group-sm">
                    <?php if (!is_right_side_currency_symbol()): ?>
                        <span class="input-group-addon input-sm"><?= esc($config['currency_symbol']) ?></span>
                    <?php endif; ?>
                    <?= form_input([
                        'name'  => 'payment_amount',
                        'id'    => 'payment_amount',
                        'class' => 'form-control input-sm',
                        'value' => to_currency_no_money($credit_balance)
                    ]) ?>
                    <?php if (is_right_side_currency_symbol()): ?>
                        <span class="input-group-addon input-sm"><?= esc($config['currency_symbol']) ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Sales.payment_type'), 'payment_type', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?= form_dropdown('payment_type', $payment_options, lang('Sales.cash'), ['id' => 'payment_type', 'class' => 'form-control input-sm']) ?>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Common.date'), 'payment_date', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-4">
                <?= form_input([
                    'name'  => 'payment_date',
                    'id'    => 'payment_date',
                    'class' => 'form-control input-sm',
                    'value' => date($config['dateformat'] . ' ' . $config['timeformat'])
                ]) ?>
            </div>
        </div>

    </fieldset>
<?= form_close() ?>

<script type="text/javascript">
    $(document).ready(function() {
        $('#receive_payment_form').validate($.extend({
            submitHandler: function(form) {
                $(form).ajaxSubmit({
                    success: function(response) {
                        dialog_support.hide();
                        table_support.handle_submit('<?= esc('customers') ?>', response);
                    },
                    error: function(jqXHR) {
                        table_support.handle_submit('<?= esc('customers') ?>', jqXHR.responseJSON || { success: false, message: jqXHR.statusText });
                    },
                    dataType: 'json'
                });
            },
            errorLabelContainer: '#error_message_box',
            rules: {
                payment_amount: {
                    required: true,
                    number: true,
                    min: 0.01
                }
            },
            messages: {
                payment_amount: {
                    required: "<?= lang('Common.fields_required_message') ?>",
                    number: "<?= lang('Sales.payment_amount') ?>"
                }
            }
        }, form_support.error));
    });
</script>
