<?php
/**
 * @var array $allowed_modules
 * @var array $dashboard
 */

$summaries = $dashboard['summaries'] ?? [];
$analysis = $dashboard['analysis'] ?? [];
$recommendations = $dashboard['recommendations'] ?? [];
$creditSales = $dashboard['credit_sales'] ?? 0;
$creditPurchase = $dashboard['credit_purchase'] ?? 0;
$receivings = $dashboard['receivings'] ?? ['today' => 0, 'week' => 0, 'month' => 0];
$transfers = $dashboard['transfers'] ?? ['today' => 0, 'week' => 0, 'month' => 0];
$itemsReceived = $dashboard['items_received'] ?? ['today' => 0, 'week' => 0, 'month' => 0];
$expenses = $dashboard['expenses'] ?? ['today' => 0, 'week' => 0, 'month' => 0];
$lowInventory = $dashboard['low_inventory'] ?? 0;
$expiringSoon = $dashboard['expiring_soon'] ?? 0;
$averageSale = $dashboard['average_sale'] ?? ['today' => 0, 'week' => 0, 'month' => 0];
$salesChart = $dashboard['sales_chart'] ?? ['labels' => [], 'series' => []];
$salesVsExpensesChart = $dashboard['sales_vs_expenses_chart'] ?? ['labels' => [], 'series' => []];
$config = $config ?? config(\Config\OSPOS::class)->settings ?? [];
?>

<?= view('partial/header') ?>

<script type="text/javascript">
    dialog_support.init("a.modal-dlg");
</script>

<div class="dashboard-container">
    <!-- Summaries Section -->
    <section class="dashboard-section dashboard-summaries">
        <h4 class="dashboard-section-title"><?= lang('Dashboard.summaries') ?></h4>
        <div class="row">
            <div class="col-sm-4">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.today') ?></div>
                    <div class="dashboard-card-value"><?= to_currency($summaries['today']['total'] ?? 0) ?></div>
                    <div class="dashboard-card-meta"><?= ($summaries['today']['count'] ?? 0) ?> <?= lang('Dashboard.transactions') ?></div>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.this_week') ?></div>
                    <div class="dashboard-card-value"><?= to_currency($summaries['week']['total'] ?? 0) ?></div>
                    <div class="dashboard-card-meta"><?= ($summaries['week']['count'] ?? 0) ?> <?= lang('Dashboard.transactions') ?></div>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.this_month') ?></div>
                    <div class="dashboard-card-value"><?= to_currency($summaries['month']['total'] ?? 0) ?></div>
                    <div class="dashboard-card-meta"><?= ($summaries['month']['count'] ?? 0) ?> <?= lang('Dashboard.transactions') ?></div>
                </div>
            </div>
        </div>
        <div class="row" style="margin-top: 15px;">
            <div class="col-sm-3">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.credit_sales') ?></div>
                    <div class="dashboard-card-value"><?= to_currency($creditSales) ?></div>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/summary_debtors') ?>"><?= lang('Reports.debtors_report') ?></a></div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.credit_purchase') ?></div>
                    <div class="dashboard-card-value"><?= to_currency($creditPurchase) ?></div>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/summary_creditors') ?>"><?= lang('Reports.creditors_report') ?></a></div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.receivings') ?></div>
                    <div class="dashboard-card-value"><?= (int) ($receivings['today'] ?? 0) ?> / <?= (int) ($receivings['week'] ?? 0) ?> / <?= (int) ($receivings['month'] ?? 0) ?></div>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/detailed_receivings') ?>"><?= lang('Dashboard.today') ?> / <?= lang('Dashboard.this_week') ?> / <?= lang('Dashboard.this_month') ?></a></div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.items_received') ?></div>
                    <div class="dashboard-card-value"><?= to_quantity_decimals($itemsReceived['today'] ?? 0) ?> / <?= to_quantity_decimals($itemsReceived['week'] ?? 0) ?> / <?= to_quantity_decimals($itemsReceived['month'] ?? 0) ?></div>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/detailed_receivings') ?>"><?= lang('Dashboard.today') ?> / <?= lang('Dashboard.this_week') ?> / <?= lang('Dashboard.this_month') ?></a></div>
                </div>
            </div>
        </div>
        <div class="row" style="margin-top: 15px;">
            <div class="col-sm-3">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.transfers') ?></div>
                    <div class="dashboard-card-value"><?= (int) ($transfers['today'] ?? 0) ?> / <?= (int) ($transfers['week'] ?? 0) ?> / <?= (int) ($transfers['month'] ?? 0) ?></div>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/detailed_transfers') ?>"><?= lang('Dashboard.today') ?> / <?= lang('Dashboard.this_week') ?> / <?= lang('Dashboard.this_month') ?></a></div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.expenses') ?></div>
                    <div class="dashboard-card-value"><?= to_currency($expenses['today'] ?? 0) ?> / <?= to_currency($expenses['week'] ?? 0) ?> / <?= to_currency($expenses['month'] ?? 0) ?></div>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/summary_expenses_categories') ?>"><?= lang('Dashboard.today') ?> / <?= lang('Dashboard.this_week') ?> / <?= lang('Dashboard.this_month') ?></a></div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.low_inventory') ?></div>
                    <div class="dashboard-card-value"><?= (int) $lowInventory ?> <?= lang('Dashboard.items') ?></div>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/inventory_low') ?>"><?= lang('Reports.inventory_low_report') ?></a></div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.expiring_soon') ?></div>
                    <div class="dashboard-card-value"><?= (int) $expiringSoon ?> <?= lang('Dashboard.items') ?></div>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/inventory_expired') ?>"><?= lang('Reports.inventory_expired') ?></a></div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="dashboard-card">
                    <div class="dashboard-card-label"><?= lang('Dashboard.average_sale') ?></div>
                    <div class="dashboard-card-value"><?= to_currency($averageSale['today'] ?? 0) ?> / <?= to_currency($averageSale['week'] ?? 0) ?> / <?= to_currency($averageSale['month'] ?? 0) ?></div>
                    <div class="dashboard-card-meta"><?= lang('Dashboard.today') ?> / <?= lang('Dashboard.this_week') ?> / <?= lang('Dashboard.this_month') ?></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Charts Section -->
    <section class="dashboard-section dashboard-charts">
        <h4 class="dashboard-section-title"><?= lang('Dashboard.sales_trend') ?></h4>
        <div class="row">
            <div class="col-md-8">
                <div class="dashboard-chart-card">
                    <h5 class="chart-title"><?= lang('Dashboard.last_7_days') ?></h5>
                    <div class="ct-chart ct-golden-section" id="dashboard-sales-chart"></div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="dashboard-chart-card">
                    <h5 class="chart-title"><?= lang('Dashboard.sales_vs_expenses') ?></h5>
                    <div class="ct-chart ct-golden-section" id="dashboard-pie-chart"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Analysis Section -->
    <section class="dashboard-section dashboard-analysis">
        <h4 class="dashboard-section-title"><?= lang('Dashboard.analysis') ?></h4>
        <div class="row">
            <div class="col-sm-4">
                <div class="dashboard-trend <?= ($analysis['today_trend'] ?? 0) >= 0 ? 'trend-up' : 'trend-down' ?>">
                    <span class="glyphicon <?= ($analysis['today_trend'] ?? 0) >= 0 ? 'glyphicon-arrow-up' : 'glyphicon-arrow-down' ?>"></span>
                    <?= lang('Dashboard.today_vs_yesterday') ?>: <?= ($analysis['today_trend'] ?? 0) ?>%
                </div>
            </div>
            <div class="col-sm-4">
                <div class="dashboard-trend <?= ($analysis['week_trend'] ?? 0) >= 0 ? 'trend-up' : 'trend-down' ?>">
                    <span class="glyphicon <?= ($analysis['week_trend'] ?? 0) >= 0 ? 'glyphicon-arrow-up' : 'glyphicon-arrow-down' ?>"></span>
                    <?= lang('Dashboard.week_vs_last_week') ?>: <?= ($analysis['week_trend'] ?? 0) ?>%
                </div>
            </div>
            <div class="col-sm-4">
                <div class="dashboard-trend <?= ($analysis['month_trend'] ?? 0) >= 0 ? 'trend-up' : 'trend-down' ?>">
                    <span class="glyphicon <?= ($analysis['month_trend'] ?? 0) >= 0 ? 'glyphicon-arrow-up' : 'glyphicon-arrow-down' ?>"></span>
                    <?= lang('Dashboard.month_vs_last_month') ?>: <?= ($analysis['month_trend'] ?? 0) ?>%
                </div>
            </div>
        </div>
    </section>

    <!-- Recommendations Section -->
    <section class="dashboard-section dashboard-recommendations">
        <h4 class="dashboard-section-title"><?= lang('Dashboard.recommendations') ?></h4>
        <?php if (empty($recommendations)) : ?>
            <p class="dashboard-no-recommendations"><?= lang('Dashboard.no_recommendations') ?></p>
        <?php else : ?>
            <ul class="dashboard-recommendations-list">
                <?php foreach ($recommendations as $rec) : ?>
                    <li class="dashboard-recommendation-item">
                        <a href="<?= $rec['type'] === 'low_inventory' ? base_url('reports/inventory_low') : ($rec['type'] === 'expiring_soon' ? base_url('reports/inventory_expired') : base_url('reports')) ?>" class="dashboard-recommendation-link">
                            <?= isset($rec['count']) ? lang('Dashboard.' . ($rec['message'] ?? $rec['type']), [$rec['count']]) : lang('Dashboard.' . ($rec['message'] ?? $rec['type'])) ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </section>

    <!-- Module Shortcuts -->
    <section class="dashboard-section dashboard-modules">
        <h4 class="dashboard-section-title"><?= lang('Dashboard.quick_access') ?></h4>
        <div id="office_module_list">
            <?php
            $menu_categories = config(\Config\MenuCategories::class);
            foreach ($allowed_modules as $module) :
                $icon = $menu_categories->getMenuIcon($module->module_id);
            ?>
                <div class="module_item" title="<?= lang("Module.$module->module_id" . '_desc') ?>">
                    <a href="<?= base_url($module->module_id) ?>">
                        <?php if ($icon !== 'svg') : ?>
                            <span class="glyphicon glyphicon-<?= esc($icon) ?> module-item-icon" aria-hidden="true"></span>
                        <?php else : ?>
                            <img src="<?= base_url("images/menubar/$module->module_id.svg") ?>" alt="" class="module-item-icon">
                        <?php endif; ?>
                    </a>
                    <a href="<?= base_url($module->module_id) ?>"><?= lang("Module.$module->module_id") ?></a>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
</div>

<script type="text/javascript">
(function() {
    var salesSeries = <?= json_encode(array_map(function ($s) { return is_array($s) ? ($s['value'] ?? 0) : $s; }, $salesChart['series'] ?? [])) ?>;
    var salesData = {
        labels: <?= json_encode(esc($salesChart['labels'] ?? [], 'js')) ?>,
        series: [{
            name: '<?= esc(lang('Reports.revenue'), 'js') ?>',
            data: salesSeries
        }]
    };

    var pieData = {
        labels: <?= json_encode(esc($salesVsExpensesChart['labels'] ?? [], 'js')) ?>,
        series: <?= json_encode(esc($salesVsExpensesChart['series'] ?? [], 'js')) ?>
    };

    var currencySymbol = '<?= esc($config['currency_symbol'] ?? '', 'js') ?>';
    var currencyRight = <?= json_encode(is_right_side_currency_symbol()) ?>;

    function fmtCurrency(value) {
        return currencyRight ? value + currencySymbol : currencySymbol + value;
    }

    if (salesData.labels.length > 0) {
        new Chartist.Bar('#dashboard-sales-chart', salesData, {
            width: '100%',
            height: '250px',
            chartPadding: { top: 20, right: 20, bottom: 60, left: 60 },
            axisX: { offset: 60, position: 'end' },
            axisY: {
                offset: 50,
                labelInterpolationFnc: function(value) { return fmtCurrency(value); }
            },
            plugins: [
                Chartist.plugins.tooltip({
                    transformTooltipTextFnc: function(value) { return fmtCurrency(value); }
                }),
                Chartist.plugins.ctBarLabels()
            ]
        });
    }

    var pieTotal = (pieData.series[0] ? pieData.series[0].value : 0) + (pieData.series[1] ? pieData.series[1].value : 0);
    if (pieTotal > 0) {
        new Chartist.Pie('#dashboard-pie-chart', pieData, {
            width: '100%',
            height: '250px',
            chartPadding: 20,
            labelPosition: 'outside',
            plugins: [
                Chartist.plugins.tooltip({
                    transformTooltipTextFnc: function(value) { return fmtCurrency(value); }
                })
            ]
        });
    } else {
        document.getElementById('dashboard-pie-chart').innerHTML = '<p class="text-muted" style="padding: 40px; text-align: center;"><?= esc(lang('Dashboard.chart_no_data'), 'js') ?></p>';
    }
})();
</script>

<?= view('partial/footer') ?>
