<?php
/**
 * @var object $item_info
 * @var array $stock_locations
 * @var array $item_quantities
 * @var string $controller_name
 */
?>

<div id="required_fields_message"><?= lang('Common.fields_required_message') ?></div>
<ul id="error_message_box" class="error_message_box"></ul>

<?= form_open("items/saveInventory/$item_info->item_id", ['id' => 'item_form', 'class' => 'form-horizontal']) ?>
    <fieldset id="inv_item_basic_info">

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.item_number'), 'name', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <div class="input-group">
                    <span class="input-group-addon input-sm"><span class="glyphicon glyphicon-barcode"></span></span>
                    <?= form_input([
                        'name'     => 'item_number',
                        'id'       => 'item_number',
                        'class'    => 'form-control input-sm',
                        'disabled' => '',
                        'value'    => $item_info->item_number
                    ]) ?>
                </div>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.name'), 'name', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?= form_input([
                    'name'     => 'name',
                    'id'       => 'name',
                    'class'    => 'form-control input-sm',
                    'disabled' => '',
                    'value'    => $item_info->name
                ]) ?>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.category'), 'category', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <div class="input-group">
                    <span class="input-group-addon input-sm"><span class="glyphicon glyphicon-tag"></span></span>
                    <?= form_input([
                        'name'     => 'category',
                        'id'       => 'category',
                        'class'    => 'form-control input-sm',
                        'disabled' => '',
                        'value'    => $item_info->category
                    ]) ?>
                </div>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.stock_location'), 'stock_location', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?= form_dropdown('stock_location', $stock_locations, current($stock_locations), ['onchange' => 'fill_quantity(this.value)', 'class' => 'form-control']) ?>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.current_quantity'), 'quantity', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?php
                $cur_qty = (float) current($item_quantities);
                $qp_cur = quantity_to_carton_pieces($cur_qty, $item_info);
                $inv_qty_per = $qp_cur['qty_per'];
                $inv_has_bulk = $qp_cur['has_bulk'];
                $cur_carton_vis = $qp_cur['has_bulk'] ? '' : ' style="display:none;"';
                ?>
                <input type="hidden" name="quantity" id="quantity" value="<?= to_quantity_decimals($cur_qty) ?>">
                <div class="row">
                    <div class="col-xs-4 current-carton-pieces-group"<?= $cur_carton_vis ?>>
                        <label class="control-label" style="font-weight: normal; font-size: 11px;"><?= lang('Sales.carton_qty') ?></label>
                        <?= form_input(['id' => 'current_carton', 'class' => 'form-control input-sm', 'disabled' => '', 'value' => to_quantity_decimals($qp_cur['carton'])]) ?>
                    </div>
                    <div class="col-xs-4 current-carton-pieces-group"<?= $cur_carton_vis ?>>
                        <label class="control-label" style="font-weight: normal; font-size: 11px;"><?= lang('Sales.pieces_qty') ?></label>
                        <?= form_input(['id' => 'current_pieces', 'class' => 'form-control input-sm', 'disabled' => '', 'value' => to_quantity_decimals($qp_cur['pieces'])]) ?>
                    </div>
                    <div class="col-xs-4 current-pieces-only"<?= $qp_cur['has_bulk'] ? ' style="display:none;"' : '' ?>>
                        <label class="control-label" style="font-weight: normal; font-size: 11px;"><?= lang('Sales.pieces_qty') ?></label>
                        <?= form_input(['id' => 'current_pieces_disp', 'class' => 'form-control input-sm', 'disabled' => '', 'value' => to_quantity_decimals($cur_qty)]) ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.add_minus'), 'newquantity', ['class' => 'required control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?php
                $qp_new = quantity_to_carton_pieces(0, $item_info);
                $cp_vis = $qp_new['has_bulk'] ? '' : ' style="display:none;"';
                $po_vis = $qp_new['has_bulk'] ? ' style="display:none;"' : '';
                ?>
                <input type="hidden" name="newquantity" id="newquantity" value="0">
                <div class="row">
                    <div class="col-xs-4 inv-carton-pieces-group"<?= $cp_vis ?>>
                        <label class="control-label" style="font-weight: normal; font-size: 11px;"><?= lang('Sales.carton_qty') ?></label>
                        <?= form_input(['id' => 'newquantity_carton', 'class' => 'form-control input-sm', 'value' => '0']) ?>
                    </div>
                    <div class="col-xs-4 inv-carton-pieces-group"<?= $cp_vis ?>>
                        <label class="control-label" style="font-weight: normal; font-size: 11px;"><?= lang('Sales.pieces_qty') ?></label>
                        <?= form_input(['id' => 'newquantity_pieces', 'class' => 'form-control input-sm', 'value' => '0']) ?>
                    </div>
                    <div class="col-xs-4 inv-pieces-only"<?= $po_vis ?>>
                        <label class="control-label" style="font-weight: normal; font-size: 11px;"><?= lang('Sales.pieces_qty') ?></label>
                        <input type="text" id="newquantity_disp" class="form-control input-sm" value="0">
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.inventory_comments'), 'description', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?= form_textarea([
                    'name'  => 'trans_comment',
                    'id'    => 'trans_comment',
                    'class' => 'form-control input-sm'
                ]) ?>
            </div>
        </div>

    </fieldset>
<?= form_close() ?>

<script type="text/javascript">
    // Validation and submit handling
    $(document).ready(function() {
        $('#item_form').validate($.extend({
            submitHandler: function(form) {
                if (invHasBulk) {
                    var carton = parseFloat($('#newquantity_carton').val()) || 0;
                    var pieces = parseFloat($('#newquantity_pieces').val()) || 0;
                    $('#newquantity').val((carton * invQtyPer) + pieces);
                } else {
                    $('#newquantity').val(parseFloat($('#newquantity_disp').val()) || 0);
                }
                $(form).ajaxSubmit({
                    success: function(response) {
                        dialog_support.hide();
                        table_support.handle_submit("<?= esc($controller_name) ?>", response);
                    },
                    dataType: 'json'
                });
            },

            errorLabelContainer: '#error_message_box',

            rules: {
                newquantity: {
                    required: true,
                    number: true
                }
            },

            messages: {
                newquantity: {
                    required: "<?= lang('Items.quantity_required') ?>",
                    number: "<?= lang('Items.quantity_number') ?>"
                }
            }
        }, form_support.error));
    });

    var invQtyPer = <?= json_encode($inv_qty_per ?? 1) ?>;
    var invHasBulk = <?= json_encode($inv_has_bulk ?? false) ?>;
    var invBulkLabel = <?= json_encode($qp_cur['bulk_label'] ?? '') ?>;
    function fill_quantity(val) {
        var item_quantities = <?= json_encode($item_quantities ?? []) ?>;
        var qty = item_quantities[val] != null ? item_quantities[val] : (item_quantities[String(val)] != null ? item_quantities[String(val)] : 0);
        var q = parseFloat(qty) || 0;
        document.getElementById('quantity').value = q.toFixed(<?= quantity_decimals() ?>);
        if (invHasBulk && invQtyPer > 0) {
            var carton = Math.floor(q / invQtyPer);
            var pieces = q - (carton * invQtyPer);
            $('#current_carton').val(carton % 1 === 0 ? carton : parseFloat(carton.toFixed(6)));
            $('#current_pieces').val(pieces % 1 === 0 ? pieces : parseFloat(pieces.toFixed(6)));
        } else {
            $('#current_pieces_disp').val(q % 1 === 0 ? q : parseFloat(q.toFixed(6)));
        }
    }

    var qtyPer = <?= json_encode($qp_new['qty_per'] ?? 1) ?>;
    var hasBulk = qtyPer > 1;
    if (hasBulk) {
        $('#newquantity_carton, #newquantity_pieces').on('input change', function() {
            var carton = parseFloat($('#newquantity_carton').val()) || 0;
            var pieces = parseFloat($('#newquantity_pieces').val()) || 0;
            var total = (carton * qtyPer) + pieces;
            $('#newquantity').val(total % 1 === 0 ? Math.round(total) : parseFloat(total.toFixed(6)));
        });
    } else {
        $('#newquantity_disp').on('input change', function() {
            var val = parseFloat($(this).val()) || 0;
            $('#newquantity').val(val % 1 === 0 ? val : parseFloat(val.toFixed(6)));
        });
    }
</script>
