<?php
/**
 * Shows received batches for an item, sorted by expire date.
 * @var object $item_info
 * @var array $stock_locations
 * @var array $received_batches
 */
?>

<div class="form-group form-group-sm">
    <div class="col-xs-12">
        <strong><?= esc($item_info->name) ?></strong> (<?= esc($item_info->item_number) ?>)
    </div>
</div>

<?php if (empty($received_batches)) { ?>
    <div class="alert alert-info"><?= lang('Items.no_received_batches') ?></div>
<?php } else {
    $config = config(\Config\OSPOS::class)->settings;
    $date_format = $config['dateformat'] ?? 'm/d/Y';
?>
<table id="items_received_batches" class="table table-striped table-hover">
    <thead>
        <tr style="background-color: #999 !important;">
            <th colspan="7"><?= lang('Items.received_batches') ?></th>
        </tr>
        <tr>
            <th style="width: 18%;"><?= lang('Items.expire_date') ?></th>
            <th style="width: 18%;"><?= lang('Receivings.id') ?></th>
            <th style="width: 18%;"><?= lang('Items.inventory_date') ?></th>
            <th style="width: 12%;"><?= lang('Reports.quantity') ?></th>
            <th style="width: 12%;"><?= lang('Sales.carton_qty') ?></th>
            <th style="width: 12%;"><?= lang('Sales.pieces_qty') ?></th>
            <th style="width: 10%;"><?= lang('Items.stock_location') ?></th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($received_batches as $batch) {
            $loc_id = $batch['item_location'] ?? 0;
            $loc_name = $stock_locations[$loc_id] ?? (string) $loc_id;
            $pieces = (float) ($batch['pieces_received'] ?? 0);
            $expire = $batch['expire_date'] ?? null;
            $bqp = quantity_to_carton_pieces($pieces, $item_info);
            ?>
        <tr>
            <td><?= $expire ? date($date_format, strtotime($expire)) : lang('Items.none') ?></td>
            <td><?= anchor('receivings/edit/' . (int) $batch['receiving_id'], 'RECV ' . (int) $batch['receiving_id'], ['class' => 'modal-dlg', 'title' => lang('Receivings.update')]) ?></td>
            <td><?= esc($batch['receiving_time']) ?></td>
            <td style="text-align: center;"><?= to_quantity_decimals($pieces) ?></td>
            <td style="text-align: center;"><?= $bqp['has_bulk'] ? to_quantity_decimals($bqp['carton']) : '0' ?></td>
            <td style="text-align: center;"><?= $bqp['has_bulk'] ? to_quantity_decimals($bqp['pieces']) : to_quantity_decimals($pieces) ?></td>
            <td><?= esc($loc_name) ?></td>
        </tr>
        <?php } ?>
    </tbody>
</table>
<?php } ?>
