<?php
/**
 * @var object $user_info
 * @var array $allowed_modules
 * @var CodeIgniter\HTTP\IncomingRequest $request
 * @var array $config
 * @var string|null $menu_group
 * @var bool $show_office_group
 */

use Config\MenuCategories;
use Config\Services;

$request = Services::request();
$menu_group = $menu_group ?? service('session')->get('menu_group') ?? 'home';
$show_office_group = $show_office_group ?? false;
$menu_categories = config(MenuCategories::class);
$segment = $request->getUri()->getSegment(1);

$grouped = $menu_categories->groupModules($allowed_modules);
$category_order = ['operations', 'catalog', 'people', 'finance', 'admin'];
?>

<!doctype html>
<html lang="<?= $request->getLocale() ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
    <base href="<?= base_url() ?>">
    <title><?= esc($config['company']) . ' | ' . lang('Common.powered_by') . ' OSPOS ' . esc(config('App')->application_version) ?></title>
    <link rel="shortcut icon" type="image/x-icon" href="<?= base_url('images/favicon.ico') ?>">
    <link rel="stylesheet" href="<?= base_url('resources/bootswatch/' . (empty($config['theme']) ? 'flatly' : esc($config['theme'])) . '/bootstrap.min.css') ?>">

    <?php if (ENVIRONMENT == 'development' || get_cookie('debug') == 'true' || $request->getGet('debug') == 'true') : ?>
        <!-- inject:debug:css -->
        <link rel="stylesheet" href="<?= base_url('resources/css/jquery-ui-fe010342cb.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/bootstrap-dialog-1716ef6e7c.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/jasny-bootstrap-40bf85f3ed.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/bootstrap-datetimepicker-66374fba71.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/bootstrap-select-66d5473b84.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/bootstrap-table-ed9d1a3360.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/bootstrap-table-sticky-header-07d65e7533.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/daterangepicker-85523b7dfe.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/chartist-c19aedb81a.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/chartist-plugin-tooltip-2e0ec92e60.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/bootstrap-tagsinput-5a6d46a06c.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/bootstrap-toggle-e12db6c1f3.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/bootstrap-4875cf7b0d.autocomplete.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/invoice-a99a4dfac3.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/ospos_print-bf10c1438b.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/ospos-28f7f540a3.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/popupbox-57d45cb822.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/receipt-0606f1c54e.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/register-a6a6cc948d.css') ?>">
        <link rel="stylesheet" href="<?= base_url('resources/css/reports-ace7faf688.css') ?>">
        <!-- endinject -->
        <!-- inject:debug:js -->
        <script src="<?= base_url('resources/js/jquery-12e87d2f3a.js') ?>"></script>
        <script src="<?= base_url('resources/js/jquery-4fa896f615.form.js') ?>"></script>
        <script src="<?= base_url('resources/js/jquery-a0350e8820.validate.js') ?>"></script>
        <script src="<?= base_url('resources/js/jquery-ui-cbc65ff85e.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-894d79839f.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-dialog-27123abb65.js') ?>"></script>
        <script src="<?= base_url('resources/js/jasny-bootstrap-7c6d7b8adf.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-datetimepicker-25e39b7ef8.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-select-b01896a67b.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-table-bdb06552ea.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-table-export-6389dc2aa5.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-table-mobile-fc655b68ab.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-table-sticky-header-cb4d83d172.js') ?>"></script>
        <script src="<?= base_url('resources/js/moment-d65dc6d2e6.min.js') ?>"></script>
        <script src="<?= base_url('resources/js/daterangepicker-048c56a690.js') ?>"></script>
        <script src="<?= base_url('resources/js/es6-promise-855125e6f5.js') ?>"></script>
        <script src="<?= base_url('resources/js/FileSaver-e73b1946e8.js') ?>"></script>
        <script src="<?= base_url('resources/js/html2canvas-e1d3a8d7cd.js') ?>"></script>
        <script src="<?= base_url('resources/js/jspdf-6eb90bf5a3.umd.js') ?>"></script>
        <script src="<?= base_url('resources/js/jspdf-4f52bd767f.plugin.autotable.js') ?>"></script>
        <script src="<?= base_url('resources/js/tableExport-0df60917ca.min.js') ?>"></script>
        <script src="<?= base_url('resources/js/chartist-8a7ecb4445.js') ?>"></script>
        <script src="<?= base_url('resources/js/chartist-plugin-pointlabels-0a1ab6aa4e.js') ?>"></script>
        <script src="<?= base_url('resources/js/chartist-plugin-tooltip-116cb48831.js') ?>"></script>
        <script src="<?= base_url('resources/js/chartist-plugin-axistitle-80a1198058.js') ?>"></script>
        <script src="<?= base_url('resources/js/chartist-plugin-barlabels-4165273742.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-notify-376bc6eb87.js') ?>"></script>
        <script src="<?= base_url('resources/js/js-fa93e8894e.cookie.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-tagsinput-855a7c7670.js') ?>"></script>
        <script src="<?= base_url('resources/js/bootstrap-toggle-1c7a19a049.js') ?>"></script>
        <script src="<?= base_url('resources/js/clipboard-908af414ab.js') ?>"></script>
        <script src="<?= base_url('resources/js/imgpreview-1db063409f.full.jquery.js') ?>"></script>
        <script src="<?= base_url('resources/js/manage_tables-9b98d5573a.js') ?>"></script>
        <script src="<?= base_url('resources/js/nominatim-89be77a11a.autocomplete.js') ?>"></script>
        <!-- endinject -->
    <?php else : ?>
        <!--inject:prod:css -->
        <link rel="stylesheet" href="<?= base_url('resources/opensourcepos-8e34d6a398.min.css') ?>">
        <!-- endinject -->
        <link rel="stylesheet" href="<?= base_url('css/header-override.css') ?>" media="all">

        <!-- Tweaks to the UI for a particular theme should drop here  -->
        <?php if ($config['theme'] != 'flatly' && file_exists(FCPATH . 'css/' . esc($config['theme']) . '.css')) { ?>
            <link rel="stylesheet" href="<?= base_url('css/' . esc($config['theme']) . '.css') ?>">
        <?php } ?>
        <!-- inject:prod:js -->
        <script src="<?= base_url('resources/jquery-2c872dbe60.min.js') ?>"></script>
        <script src="<?= base_url('resources/opensourcepos-39c74204a5.min.js') ?>"></script>
        <!-- endinject -->
    <?php endif; ?>

    <?= view('partial/header_js') ?>
    <?= view('partial/lang_lines') ?>

    <style>
        html {
            overflow: auto;
        }
    </style>
</head>

<body>
    <div class="wrapper">
        <div class="topbar">
            <div class="container topbar-inner">
                <div class="topbar-left">
                    <div id="liveclock"><?= date($config['dateformat'] . ' ' . $config['timeformat']) ?></div>
                    <?php if ($show_office_group) : ?>
                        <span class="topbar-sep">|</span>
                        <?php if ($menu_group === 'home') : ?>
                            <a href="<?= base_url('office') ?>" class="topbar-link"><?= lang('Module.office') ?></a>
                        <?php else : ?>
                            <a href="<?= base_url('home') ?>" class="topbar-link"><?= lang('Module.home') ?></a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>

                <div class="topbar-center">
                    <strong><?= esc($config['company']) ?></strong>
                </div>

                <div class="topbar-right">
                    <?= anchor("home/changePassword/$user_info->person_id", "$user_info->first_name $user_info->last_name", ['class' => 'modal-dlg topbar-link', 'data-btn-submit' => lang('Common.submit'), 'title' => lang('Employees.change_password')]) ?>
                    <span class="topbar-sep">|</span>
                    <?= anchor('home/logout', lang('Login.logout'), ['class' => 'topbar-link']) ?>
                </div>
            </div>
        </div>

        <nav class="navbar navbar-default navbar-modern" role="navigation" aria-label="<?= lang('Common.menu') ?>">
            <div class="container">
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-main" aria-expanded="false" aria-controls="navbar-main">
                        <span class="sr-only"><?= lang('Common.toggle_navigation') ?></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>

                    <a class="navbar-brand" href="<?= site_url() ?>" title="<?= esc($config['company']) ?>">
                        <?php if (!empty($config['company_logo'])) : ?>
                            <img src="<?= base_url('uploads/' . esc($config['company_logo'])) ?>" alt="<?= esc($config['company']) ?>" class="navbar-brand-img">
                        <?php else : ?>
                            <?= esc($config['company']) ?>
                        <?php endif; ?>
                    </a>
                </div>

                <div id="navbar-main" class="navbar-collapse collapse">
                    <ul class="nav navbar-nav navbar-right">
                        <?php foreach ($grouped['ungrouped'] as $module) : ?>
                            <?php
                            $is_active = $module->module_id === $segment;
                            $icon = $menu_categories->getMenuIcon($module->module_id);
                            ?>
                            <li class="<?= $is_active ? 'active' : '' ?>">
                                <a href="<?= base_url($module->module_id) ?>" title="<?= lang("Module.$module->module_id") ?>" class="menu-icon" <?= $is_active ? ' aria-current="page"' : '' ?>>
                                    <?php if ($icon !== 'svg') : ?>
                                        <span class="glyphicon glyphicon-<?= esc($icon) ?>" aria-hidden="true"></span>
                                    <?php else : ?>
                                        <img src="<?= base_url("images/menubar/{$module->module_id}.svg") ?>" alt="" loading="lazy" aria-hidden="true">
                                    <?php endif; ?>
                                    <span><?= lang('Module.' . $module->module_id) ?></span>
                                </a>
                            </li>
                        <?php endforeach; ?>

                        <?php foreach ($category_order as $cat_key) : ?>
                            <?php if (!isset($grouped['groups'][$cat_key])) continue; ?>
                            <?php $cat_modules = $grouped['groups'][$cat_key]; ?>
                            <?php if (count($cat_modules) >= $menu_categories->dropdownThreshold) : ?>
                                <?php
                                $cat_has_active = false;
                                foreach ($cat_modules as $m) {
                                    if ($m->module_id === $segment) { $cat_has_active = true; break; }
                                }
                                ?>
                                <li class="dropdown <?= $cat_has_active ? 'active' : '' ?>">
                                    <a href="#" class="dropdown-toggle menu-icon" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false" title="<?= lang("Config.menu_category_$cat_key") ?>">
                                        <span class="glyphicon glyphicon-folder-open" aria-hidden="true"></span>
                                        <span><?= lang("Config.menu_category_$cat_key") ?></span>
                                        <span class="caret"></span>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <?php foreach ($cat_modules as $module) : ?>
                                            <?php
                                            $is_active = $module->module_id === $segment;
                                            $icon = $menu_categories->getMenuIcon($module->module_id);
                                            ?>
                                            <li class="<?= $is_active ? 'active' : '' ?>">
                                                <a href="<?= base_url($module->module_id) ?>" <?= $is_active ? ' aria-current="page"' : '' ?>>
                                                    <?php if ($icon !== 'svg') : ?>
                                                        <span class="glyphicon glyphicon-<?= esc($icon) ?>" aria-hidden="true" style="margin-right: 8px;"></span>
                                                    <?php else : ?>
                                                        <img src="<?= base_url("images/menubar/{$module->module_id}.svg") ?>" alt="" loading="lazy" class="dropdown-menu-icon" aria-hidden="true">
                                                    <?php endif; ?>
                                                    <?= lang('Module.' . $module->module_id) ?>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </li>
                            <?php else : ?>
                                <?php foreach ($cat_modules as $module) : ?>
                                    <?php
                                    $is_active = $module->module_id === $segment;
                                    $icon = $menu_categories->getMenuIcon($module->module_id);
                                    ?>
                                    <li class="<?= $is_active ? 'active' : '' ?>">
                                        <a href="<?= base_url($module->module_id) ?>" title="<?= lang("Module.$module->module_id") ?>" class="menu-icon" <?= $is_active ? ' aria-current="page"' : '' ?>>
                                            <?php if ($icon !== 'svg') : ?>
                                                <span class="glyphicon glyphicon-<?= esc($icon) ?>" aria-hidden="true"></span>
                                            <?php else : ?>
                                                <img src="<?= base_url("images/menubar/{$module->module_id}.svg") ?>" alt="" loading="lazy" aria-hidden="true">
                                            <?php endif; ?>
                                            <span><?= lang('Module.' . $module->module_id) ?></span>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </nav>

        <div class="container">
            <div class="row">