<?php
/**
 * @var string $controller_name
 * @var string $table_headers
 * @var array $config
 */
?>

<?= view('partial/header') ?>

<script type="text/javascript">
    $(document).ready(function() {
        <?= view('partial/daterangepicker') ?>

        // Default Daily Receivings to "all time" (2010 to today) so records are more likely to show
        start_date = "2010-01-01";
        end_date = "<?= date('Y-m-d') ?>";
        <?php if (!empty($config['date_or_time_format'])) { ?>
        start_date = "2010-01-01 00:00:00";
        end_date = "<?= date('Y-m-d 23:59:59') ?>";
        <?php } ?>
        var $drp = $('#daterangepicker').data('daterangepicker');
        if ($drp) {
            $drp.setStartDate(moment(start_date));
            $drp.setEndDate(moment(end_date));
        }

        $("#daterangepicker").on('apply.daterangepicker', function(ev, picker) {
            table_support.refresh();
        });

        <?= view('partial/bootstrap_tables_locale') ?>

        table_support.query_params = function() {
            return {
                "start_date": start_date,
                "end_date": end_date
            }
        };

        table_support.init({
            resource: '<?= esc($controller_name) ?>',
            headers: <?= $table_headers ?>,
            pageSize: <?= $config['lines_per_page'] ?>,
            uniqueId: 'receiving_id',
            onLoadSuccess: function(response) {
                if ($("#table tbody tr").length > 1) {
                    $("#table tbody tr:last td:first").html("");
                    $("#table tbody tr:last").css('font-weight', 'bold');
                }
            },
            queryParams: function(params) {
                return $.extend(params, table_support.query_params());
            }
        });
    });
</script>

<div id="title_bar" class="print_hide btn-toolbar">
    <button onclick="javascript:printdoc()" class="btn btn-info btn-sm pull-right">
        <span class="glyphicon glyphicon-print">&nbsp;</span><?= lang('Common.print') ?>
    </button>
    <?= anchor("receivings", '<span class="glyphicon glyphicon-inbox">&nbsp;</span>' . lang('Receivings.register'), ['class' => 'btn btn-info btn-sm pull-right', 'id' => 'show_receivings_button']) ?>
</div>

<div id="toolbar">
    <div class="pull-left form-inline" role="toolbar">
        <button id="delete" class="btn btn-default btn-sm print_hide">
            <span class="glyphicon glyphicon-trash">&nbsp;</span><?= lang('Common.delete') ?>
        </button>
        <?= form_input(['name' => 'daterangepicker', 'class' => 'form-control input-sm', 'id' => 'daterangepicker']) ?>
    </div>
</div>

<div id="table_holder">
    <table id="table"></table>
</div>

<?= view('partial/footer') ?>
