<?php
/**
 * @var string $supplier_name
 * @var array $receivings
 * @var array $config
 */
?>

<?= view('partial/header') ?>

<div id="title_bar" class="btn-toolbar">
    <?= anchor('suppliers', '<span class="glyphicon glyphicon-arrow-left">&nbsp;</span>' . lang('Common.back'), ['class' => 'btn btn-info btn-sm']) ?>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Suppliers.total_purchase') ?> - <?= esc($supplier_name) ?></h3>
    </div>
    <div class="panel-body">
        <?php if (empty($receivings)): ?>
            <p><?= lang('Suppliers.no_receivings') ?></p>
        <?php else: ?>
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th><?= lang('Common.id') ?></th>
                        <th><?= lang('Receivings.date') ?></th>
                        <th><?= lang('Sales.amount_due') ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($receivings as $receiving): ?>
                        <tr>
                            <td><?= esc($receiving->receiving_id) ?></td>
                            <td><?= to_datetime(strtotime($receiving->receiving_time)) ?></td>
                            <td><?= to_currency($receiving->total) ?></td>
                            <td><?= anchor('receivings/receipt/' . $receiving->receiving_id, '<span class="glyphicon glyphicon-usd"></span>', ['target' => '_blank', 'title' => lang('Receivings.receipt_number')]) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?= view('partial/footer') ?>
