<?php
/**
 * @var string $controller_name
 * @var object $transfer
 */
$config = config('OSPOS')->settings ?? [];
?>

<?= view('partial/header') ?>

<div id="title_bar" class="print_hide btn-toolbar">
    <?= anchor($controller_name, '<span class="glyphicon glyphicon-list">&nbsp;</span>' . lang('Transfers.transfers'), ['class' => 'btn btn-info btn-sm']) ?>
    <?= anchor($controller_name . '/add', '<span class="glyphicon glyphicon-plus">&nbsp;</span>' . lang('Transfers.transfer'), ['class' => 'btn btn-info btn-sm']) ?>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Transfers.transfer') ?> #<?= esc($transfer->transfer_id) ?></h3>
    </div>
    <div class="panel-body">
        <dl class="dl-horizontal">
            <dt><?= lang('Transfers.from_branch') ?></dt>
            <dd><?= esc($transfer->from_location_name ?? '') ?></dd>
            <dt><?= lang('Transfers.to_branch') ?></dt>
            <dd><?= esc($transfer->to_location_name ?? '') ?></dd>
            <dt><?= lang('Reports.date') ?></dt>
            <dd><?= date($config['dateformat'] ?? 'Y-m-d H:i', strtotime($transfer->transfer_time ?? 'now')) ?></dd>
            <dt><?= lang('Reports.employee') ?></dt>
            <dd><?= esc($transfer->employee_name ?? '') ?></dd>
            <?php if (!empty($transfer->comment)) : ?>
                <dt><?= lang('Transfers.comment') ?></dt>
                <dd><?= esc($transfer->comment) ?></dd>
            <?php endif; ?>
        </dl>
    </div>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Transfers.transfer_items') ?></h3>
    </div>
    <div class="panel-body">
        <table class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th><?= lang('Transfers.item') ?></th>
                    <th><?= lang('Sales.carton_qty') ?></th>
                    <th><?= lang('Sales.pieces_qty') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transfer->items ?? [] as $item) :
                    $qp = quantity_to_carton_pieces((float) ($item->quantity ?? 0), $item);
                    ?>
                    <tr>
                        <td><?= esc(trim($item->name ?? '') ?: ($item->item_number ?? '-')) ?></td>
                        <td><?= $qp['has_bulk'] ? to_quantity_decimals($qp['carton']) : '&ndash;' ?></td>
                        <td><?= to_quantity_decimals($qp['pieces']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?= view('partial/footer') ?>
