<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_receivings_menu_visibility extends Migration
{
    /**
     * Set receivings and sales menu_group to 'both' so they show in office navigation.
     * After the 3.1.1_to_3.2.0 migration added menu_group, existing grants defaulted
     * to 'home', hiding them from the office sidebar.
     */
    public function up(): void
    {
        $prefix = $this->db->prefixTable('grants');
        $this->db->query("UPDATE {$prefix} SET menu_group = 'both' WHERE permission_id IN ('receivings', 'sales')");
    }

    public function down(): void
    {
        $prefix = $this->db->prefixTable('grants');
        $this->db->query("UPDATE {$prefix} SET menu_group = 'home' WHERE permission_id IN ('receivings', 'sales')");
    }
}
