<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_receivings_items_unit_price_precision extends Migration
{
    /**
     * Increase item_unit_price precision to avoid rounding error when entering bulk cost.
     * E.g. User enters 200 for 1 carton of 24: per-piece = 8.333333; with 2 decimals we stored 8.33
     * giving 199.92 on display. With 6 decimals we store 8.333333 and display 200.00 correctly.
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $table = $prefix . 'receivings_items';

        if ($this->db->tableExists($table)) {
            $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `item_unit_price` decimal(15,6) NOT NULL");
        }
    }

    public function down(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $table = $prefix . 'receivings_items';

        if ($this->db->tableExists($table)) {
            $this->db->query("ALTER TABLE `{$table}` MODIFY COLUMN `item_unit_price` decimal(15,2) NOT NULL");
        }
    }
}
