<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_add_batch_number_to_receivings_items extends Migration
{
    /**
     * Add batch_number to receivings_items for lot/batch tracking.
     * Enables capturing supplier lot numbers or batch identifiers per receiving line.
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $table = $prefix . 'receivings_items';

        if ($this->db->tableExists($table) && !$this->db->fieldExists('batch_number', $table)) {
            $this->db->query("ALTER TABLE `{$table}` ADD COLUMN `batch_number` varchar(50) DEFAULT NULL AFTER `expire_date`");
        }
    }

    public function down(): void
    {
        $prefix = $this->db->getPrefix() ?: '';
        $table = $prefix . 'receivings_items';

        if ($this->db->fieldExists('batch_number', $table)) {
            $this->db->query("ALTER TABLE `{$table}` DROP COLUMN `batch_number`");
        }
    }
}
