<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Migration_add_payment_reference_and_due_date extends Migration
{
    /**
     * Add payment_reference (account number, mobile money number, etc.) and due_date (for On Credit)
     * to sales_payments and receivings_payments for tracking payment details.
     */
    public function up(): void
    {
        $prefix = $this->db->getPrefix() ?: '';

        $salesTable = $prefix . 'sales_payments';
        if ($this->db->tableExists($salesTable) && !$this->db->fieldExists('payment_reference', $salesTable)) {
            $after = $this->db->fieldExists('reference_code', $salesTable) ? 'reference_code' : 'payment_time';
            $this->db->query("ALTER TABLE `{$salesTable}` ADD COLUMN `payment_reference` varchar(100) DEFAULT NULL AFTER `{$after}`");
        }
        if ($this->db->tableExists($salesTable) && !$this->db->fieldExists('due_date', $salesTable)) {
            $this->db->query("ALTER TABLE `{$salesTable}` ADD COLUMN `due_date` date DEFAULT NULL AFTER `payment_reference`");
        }

        $recvTable = $prefix . 'receivings_payments';
        if ($this->db->tableExists($recvTable) && !$this->db->fieldExists('payment_reference', $recvTable)) {
            $this->db->query("ALTER TABLE `{$recvTable}` ADD COLUMN `payment_reference` varchar(100) DEFAULT NULL AFTER `payment_time`");
        }
        if ($this->db->tableExists($recvTable) && !$this->db->fieldExists('due_date', $recvTable)) {
            $this->db->query("ALTER TABLE `{$recvTable}` ADD COLUMN `due_date` date DEFAULT NULL AFTER `payment_reference`");
        }

        $receivingsTable = $prefix . 'receivings';
        if ($this->db->tableExists($receivingsTable) && !$this->db->fieldExists('payment_reference', $receivingsTable)) {
            $this->db->query("ALTER TABLE `{$receivingsTable}` ADD COLUMN `payment_reference` varchar(100) DEFAULT NULL AFTER `payment_type`");
        }
        if ($this->db->tableExists($receivingsTable) && !$this->db->fieldExists('due_date', $receivingsTable)) {
            $this->db->query("ALTER TABLE `{$receivingsTable}` ADD COLUMN `due_date` date DEFAULT NULL AFTER `payment_reference`");
        }
    }

    public function down(): void
    {
        $prefix = $this->db->getPrefix() ?: '';

        $salesTable = $prefix . 'sales_payments';
        if ($this->db->fieldExists('payment_reference', $salesTable)) {
            $this->db->query("ALTER TABLE `{$salesTable}` DROP COLUMN `payment_reference`");
        }
        if ($this->db->fieldExists('due_date', $salesTable)) {
            $this->db->query("ALTER TABLE `{$salesTable}` DROP COLUMN `due_date`");
        }

        $recvTable = $prefix . 'receivings_payments';
        if ($this->db->fieldExists('payment_reference', $recvTable)) {
            $this->db->query("ALTER TABLE `{$recvTable}` DROP COLUMN `payment_reference`");
        }
        if ($this->db->fieldExists('due_date', $recvTable)) {
            $this->db->query("ALTER TABLE `{$recvTable}` DROP COLUMN `due_date`");
        }

        $receivingsTable = $prefix . 'receivings';
        if ($this->db->fieldExists('payment_reference', $receivingsTable)) {
            $this->db->query("ALTER TABLE `{$receivingsTable}` DROP COLUMN `payment_reference`");
        }
        if ($this->db->fieldExists('due_date', $receivingsTable)) {
            $this->db->query("ALTER TABLE `{$receivingsTable}` DROP COLUMN `due_date`");
        }
    }
}
