<?php
/**
 * @var array $licenses
 * @var \App\Libraries\LicenseService|null $license_service
 */
$license_service = $license_service ?? new \App\Libraries\LicenseService();
$license_result  = $license_service->verify();
$license_active  = ($license_result['valid'] ?? false) && ($license_result['status'] ?? '') === 'active';
?>

<div class="form-horizontal">
    <h4><?= lang('License.activate') ?></h4>
    <p class="help-block"><?= lang('License.license_key_help') ?></p>
    <?= form_open('license/verify', ['id' => 'gts_license_form', 'class' => 'form-horizontal']) ?>
        <?= form_hidden('redirect', 'config') ?>
        <div class="form-group form-group-sm">
            <?= form_label(lang('License.license_key'), 'gts_license_key', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-6">
                <?= form_input([
                    'name'  => 'license_key',
                    'id'    => 'gts_license_key',
                    'class' => 'form-control input-sm',
                    'value' => $license_service->getLicenseKey(),
                ]) ?>
            </div>
        </div>
        <div class="form-group form-group-sm">
            <?= form_label(lang('License.secret_token'), 'gts_secret_token', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-6">
                <?= form_input([
                    'name'  => 'secret_token',
                    'id'    => 'gts_secret_token',
                    'class' => 'form-control input-sm',
                    'value' => $license_service->getSecretToken(),
                ]) ?>
                <span class="help-block"><?= lang('License.secret_token_help') ?></span>
            </div>
        </div>
        <div class="form-group form-group-sm">
            <div class="col-xs-offset-3 col-xs-6">
                <button type="submit" class="btn btn-primary btn-sm"><?= lang('License.submit') ?></button>
                <?php if ($license_active && ! empty($license_result['expires_at'] ?? '')): ?>
                    <span class="text-success"> &bull; <?= lang('License.success') ?> Expires: <?= esc($license_result['expires_at']) ?></span>
                <?php endif; ?>
            </div>
        </div>
    <?= form_close() ?>
</div>

<hr>

<?= form_open('', ['id' => 'license_config_form', 'enctype' => 'multipart/form-data', 'class' => 'form-horizontal']) ?>
    <div id="config_wrapper">
        <fieldset>

            <?php
            $counter = 0;
            foreach ($licenses as $license) {
            ?>
                <div class="form-group form-group-sm">
                    <?= form_label($license['title'], 'license', ['class' => 'control-label col-xs-3']) ?>
                    <div class="col-xs-6">
                        <?= form_textarea([
                            'name'     => 'license',
                            'id'       => 'license_' . $counter++,    // TODO: String Interpolation
                            'class'    => 'form-control font-monospace',
                            'rows'     => '14',
                            'readonly' => '',
                            'value'    => $license['text']
                        ]) ?>
                    </div>
                </div>
            <?php } ?>

        </fieldset>
    </div>
<?= form_close() ?>
