<?php
/**
 * @var array $allowed_modules
 * @var array $dashboard
 * @var object|null $user_info
 * @var string $current_date
 */

$summaries = $dashboard['summaries'] ?? [];
$analysis = $dashboard['analysis'] ?? [];
$recommendations = $dashboard['recommendations'] ?? [];
$creditSales = $dashboard['credit_sales'] ?? 0;
$creditPurchase = $dashboard['credit_purchase'] ?? 0;
$receivings = $dashboard['receivings'] ?? ['today' => 0, 'week' => 0, 'month' => 0];
$transfers = $dashboard['transfers'] ?? ['today' => 0, 'week' => 0, 'month' => 0];
$itemsReceived = $dashboard['items_received'] ?? ['today' => 0, 'week' => 0, 'month' => 0];
$expenses = $dashboard['expenses'] ?? ['today' => 0, 'week' => 0, 'month' => 0];
$lowInventory = $dashboard['low_inventory'] ?? 0;
$expiringSoon = $dashboard['expiring_soon'] ?? 0;
$salesChart = $dashboard['sales_chart'] ?? ['labels' => [], 'series' => []];
$debtors = $dashboard['debtors'] ?? [];
$creditors = $dashboard['creditors'] ?? [];
$expiringItems = $dashboard['expiring_items'] ?? [];
$outOfStockItems = $dashboard['out_of_stock_items'] ?? [];
$salesVsExpensesChart = $dashboard['sales_vs_expenses_chart'] ?? ['labels' => [], 'series' => []];
$config = $config ?? config(\Config\OSPOS::class)->settings ?? [];
$current_date = $current_date ?? date('m/d/Y');
$user_name = isset($user_info) && is_object($user_info) ? trim(($user_info->first_name ?? '') . ' ' . ($user_info->last_name ?? '')) : '';
$todayTrend = $analysis['today_trend'] ?? 0;
$weekTrend = $analysis['week_trend'] ?? 0;
$monthTrend = $analysis['month_trend'] ?? 0;
?>

<?= view('partial/header') ?>
<link rel="stylesheet" href="<?= base_url('css/dashboard.css') ?>" media="all">

<script type="text/javascript">
    dialog_support.init("a.modal-dlg");
</script>

<div class="col-xs-12">
<div class="dashboard-wrapper dashboard-board-style">
    <header class="dashboard-header">
        <h2 class="dashboard-welcome"><?= lang('Dashboard.welcome_back', [$user_name ?: lang('Dashboard.guest')]) ?></h2>
        <p class="dashboard-date"><?= $current_date ?></p>
    </header>

<div class="dashboard-container">
    <!-- Top Row: 4 KPI Cards -->
    <section class="dashboard-row dashboard-kpi-row">
        <div class="row">
            <div class="col-md-3 col-sm-6">
                <div class="dashboard-kpi-card">
                    <span class="dashboard-kpi-icon glyphicon glyphicon-calendar"></span>
                    <div class="dashboard-kpi-label"><?= lang('Dashboard.today') ?></div>
                    <div class="dashboard-kpi-value"><?= to_currency($summaries['today']['total'] ?? 0) ?></div>
                    <div class="dashboard-kpi-trend <?= $todayTrend >= 0 ? 'trend-up' : 'trend-down' ?>">
                        <span class="glyphicon <?= $todayTrend >= 0 ? 'glyphicon-arrow-up' : 'glyphicon-arrow-down' ?>"></span>
                        <?= abs($todayTrend) ?>% <?= lang('Dashboard.trend_vs_prev') ?>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6">
                <div class="dashboard-kpi-card">
                    <span class="dashboard-kpi-icon glyphicon glyphicon-stats"></span>
                    <div class="dashboard-kpi-label"><?= lang('Dashboard.this_week') ?></div>
                    <div class="dashboard-kpi-value"><?= to_currency($summaries['week']['total'] ?? 0) ?></div>
                    <div class="dashboard-kpi-trend <?= $weekTrend >= 0 ? 'trend-up' : 'trend-down' ?>">
                        <span class="glyphicon <?= $weekTrend >= 0 ? 'glyphicon-arrow-up' : 'glyphicon-arrow-down' ?>"></span>
                        <?= abs($weekTrend) ?>% <?= lang('Dashboard.trend_vs_prev') ?>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6">
                <div class="dashboard-kpi-card">
                    <span class="dashboard-kpi-icon glyphicon glyphicon-euro"></span>
                    <div class="dashboard-kpi-label"><?= lang('Dashboard.this_month') ?></div>
                    <div class="dashboard-kpi-value"><?= to_currency($summaries['month']['total'] ?? 0) ?></div>
                    <div class="dashboard-kpi-trend <?= $monthTrend >= 0 ? 'trend-up' : 'trend-down' ?>">
                        <span class="glyphicon <?= $monthTrend >= 0 ? 'glyphicon-arrow-up' : 'glyphicon-arrow-down' ?>"></span>
                        <?= abs($monthTrend) ?>% <?= lang('Dashboard.trend_vs_prev') ?>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6">
                <div class="dashboard-kpi-card dashboard-kpi-card-brand">
                    <?php if (!empty($config['company_logo'])) : ?>
                        <img src="<?= base_url('uploads/' . esc($config['company_logo'])) ?>" alt="<?= esc($config['company'] ?? '') ?>" class="dashboard-brand-logo">
                    <?php endif; ?>
                    <div class="dashboard-brand-name"><?= esc($config['company'] ?? 'OSPOS') ?></div>
                    <div class="dashboard-brand-meta"><?= ($summaries['today']['count'] ?? 0) ?> <?= lang('Dashboard.transactions') ?> <?= lang('Dashboard.today') ?></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Middle Row: Summary Table + Details + Status -->
    <section class="dashboard-row dashboard-middle-row">
        <div class="row">
            <div class="col-md-8">
                <div class="dashboard-summary-card">
                    <h4 class="dashboard-card-heading"><?= lang('Dashboard.summary') ?></h4>
                    <div class="dashboard-summary-table-wrapper">
                        <table class="table dashboard-summary-table">
                            <thead>
                                <tr>
                                    <th><?= lang('Dashboard.revenue') ?></th>
                                    <th class="text-right"><?= lang('Dashboard.today') ?></th>
                                    <th class="text-right"><?= lang('Dashboard.this_week') ?></th>
                                    <th class="text-right"><?= lang('Dashboard.this_month') ?></th>
                                    <th class="text-center"><?= lang('Dashboard.analysis') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><?= lang('Dashboard.revenue') ?></td>
                                    <td class="text-right"><?= to_currency($summaries['today']['total'] ?? 0) ?></td>
                                    <td class="text-right"><?= to_currency($summaries['week']['total'] ?? 0) ?></td>
                                    <td class="text-right"><?= to_currency($summaries['month']['total'] ?? 0) ?></td>
                                    <td class="text-center">
                                        <span class="dashboard-var <?= $monthTrend >= 0 ? 'var-up' : 'var-down' ?>">
                                            <?= $monthTrend >= 0 ? '↑' : '↓' ?> <?= abs($monthTrend) ?>%
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?= lang('Dashboard.credit_sales') ?></td>
                                    <td class="text-right" colspan="3"><?= to_currency($creditSales) ?></td>
                                    <td class="text-center">—</td>
                                </tr>
                                <tr>
                                    <td><?= lang('Dashboard.credit_purchase') ?></td>
                                    <td class="text-right" colspan="3"><?= to_currency($creditPurchase) ?></td>
                                    <td class="text-center">—</td>
                                </tr>
                                <tr>
                                    <td><?= lang('Dashboard.expenses') ?></td>
                                    <td class="text-right"><?= to_currency($expenses['today'] ?? 0) ?></td>
                                    <td class="text-right"><?= to_currency($expenses['week'] ?? 0) ?></td>
                                    <td class="text-right"><?= to_currency($expenses['month'] ?? 0) ?></td>
                                    <td class="text-center">—</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="dashboard-details-card">
                    <h4 class="dashboard-card-heading"><?= lang('Dashboard.details') ?></h4>
                    <div class="dashboard-details-list">
                        <div class="dashboard-detail-item">
                            <span class="detail-label"><?= lang('Dashboard.receivings') ?></span>
                            <span class="detail-value"><?= (int) ($receivings['today'] ?? 0) ?> / <?= (int) ($receivings['week'] ?? 0) ?> / <?= (int) ($receivings['month'] ?? 0) ?></span>
                        </div>
                        <div class="dashboard-detail-item">
                            <span class="detail-label"><?= lang('Dashboard.transfers') ?></span>
                            <span class="detail-value"><?= (int) ($transfers['today'] ?? 0) ?> / <?= (int) ($transfers['week'] ?? 0) ?> / <?= (int) ($transfers['month'] ?? 0) ?></span>
                        </div>
                        <div class="dashboard-detail-item">
                            <span class="detail-label"><?= lang('Dashboard.items_received') ?></span>
                            <span class="detail-value"><?= to_quantity_decimals($itemsReceived['today'] ?? 0) ?> / <?= to_quantity_decimals($itemsReceived['week'] ?? 0) ?> / <?= to_quantity_decimals($itemsReceived['month'] ?? 0) ?></span>
                        </div>
                        <div class="dashboard-detail-item">
                            <span class="detail-label"><?= lang('Dashboard.low_inventory') ?></span>
                            <span class="detail-value"><?= (int) $lowInventory ?> <?= lang('Dashboard.items') ?></span>
                        </div>
                        <div class="dashboard-detail-item">
                            <span class="detail-label"><?= lang('Dashboard.expiring_soon') ?></span>
                            <span class="detail-value"><?= (int) $expiringSoon ?> <?= lang('Dashboard.items') ?></span>
                        </div>
                    </div>
                    <div class="dashboard-details-links">
                        <a href="<?= base_url('reports/detailed_receivings') ?>"><?= lang('Reports.detailed_receivings_report') ?></a>
                        <a href="<?= base_url('reports/inventory_low') ?>"><?= lang('Reports.inventory_low_report') ?></a>
                    </div>
                </div>
                <div class="dashboard-status-card">
                    <h4 class="dashboard-card-heading"><?= lang('Dashboard.status') ?></h4>
                    <p class="dashboard-status-message">
                        <?php if (empty($recommendations)) : ?>
                            <?= lang('Dashboard.no_recommendations') ?>
                        <?php else : ?>
                            <?php foreach (array_slice($recommendations, 0, 2) as $rec) : ?>
                                <?= isset($rec['count']) ? lang('Dashboard.' . ($rec['message'] ?? $rec['type']), [$rec['count']]) : lang('Dashboard.' . ($rec['message'] ?? $rec['type'])) ?><br>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Bottom Row: Two Charts -->
    <section class="dashboard-row dashboard-charts-row">
        <div class="row">
            <div class="col-md-6">
                <div class="dashboard-chart-card">
                    <h5 class="chart-title"><?= lang('Dashboard.sales_trend') ?> (<?= lang('Dashboard.last_7_days') ?>)</h5>
                    <div class="ct-chart ct-golden-section" id="dashboard-sales-chart"><?php if (empty($salesChart['labels'])) : ?><p class="text-muted dashboard-chart-empty"><?= lang('Dashboard.chart_no_data') ?></p><?php endif; ?></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="dashboard-chart-card">
                    <h5 class="chart-title"><?= lang('Dashboard.sales_vs_expenses') ?></h5>
                    <div class="ct-chart ct-golden-section" id="dashboard-pie-chart"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Debtors & Creditors -->
    <section class="dashboard-section dashboard-debtors-creditors">
        <div class="row">
            <div class="col-md-6">
                <div class="dashboard-chart-card">
                    <h5 class="chart-title"><?= lang('Dashboard.debtors_due') ?></h5>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/summary_debtors') ?>"><?= lang('Reports.debtors_report') ?></a></div>
                    <?php if (empty($debtors)) : ?>
                        <p class="dashboard-empty-state"><?= lang('Dashboard.no_debtors') ?></p>
                    <?php else : ?>
                        <div class="dashboard-table-wrapper">
                        <table class="table table-striped table-condensed table-bordered dashboard-table">
                            <thead>
                                <tr>
                                    <th><?= lang('Reports.customer') ?></th>
                                    <th class="text-right"><?= lang('Reports.amount_due') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($debtors as $d) : ?>
                                    <tr>
                                        <td><a href="<?= base_url('customers/view/' . $d['person_id']) ?>"><?= esc($d['name']) ?></a></td>
                                        <td class="text-right"><?= to_currency($d['amount_due']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="dashboard-chart-card">
                    <h5 class="chart-title"><?= lang('Dashboard.creditors_due') ?></h5>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/summary_creditors') ?>"><?= lang('Reports.creditors_report') ?></a></div>
                    <?php if (empty($creditors)) : ?>
                        <p class="dashboard-empty-state"><?= lang('Dashboard.no_creditors') ?></p>
                    <?php else : ?>
                        <div class="dashboard-table-wrapper">
                        <table class="table table-striped table-condensed table-bordered dashboard-table">
                            <thead>
                                <tr>
                                    <th><?= lang('Reports.supplier') ?></th>
                                    <th class="text-right"><?= lang('Reports.credit_balance') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($creditors as $c) : ?>
                                    <tr>
                                        <td><a href="<?= base_url('suppliers/view/' . $c['person_id']) ?>"><?= esc($c['name']) ?></a></td>
                                        <td class="text-right"><?= to_currency($c['credit_balance']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Expiring Items & Out of Stock -->
    <section class="dashboard-section dashboard-inventory-alerts">
        <div class="row">
            <div class="col-md-6">
                <div class="dashboard-chart-card">
                    <h5 class="chart-title"><?= lang('Dashboard.expiring_items') ?></h5>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/inventory_expired') ?>"><?= lang('Reports.expired_near_expire_report') ?></a></div>
                    <?php if (empty($expiringItems)) : ?>
                        <p class="dashboard-empty-state"><?= lang('Dashboard.no_expiring_items') ?></p>
                    <?php else : ?>
                        <div class="dashboard-table-wrapper">
                        <table class="table table-striped table-condensed table-bordered dashboard-table">
                            <thead>
                                <tr>
                                    <th><?= lang('Reports.item_name') ?></th>
                                    <th><?= lang('Items.expire_date') ?></th>
                                    <th class="text-right"><?= lang('Reports.total_quantity') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($expiringItems as $e) : ?>
                                    <tr>
                                        <td><a href="<?= base_url('items/view/' . $e['item_id']) ?>"><?= esc($e['name']) ?></a></td>
                                        <td><?= esc($e['expire_date']) ?></td>
                                        <td class="text-right"><?= to_quantity_decimals($e['quantity']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="dashboard-chart-card">
                    <h5 class="chart-title"><?= lang('Dashboard.out_of_stock_items') ?></h5>
                    <div class="dashboard-card-meta"><a href="<?= base_url('reports/inventory_low') ?>"><?= lang('Reports.inventory_low_report') ?></a></div>
                    <?php if (empty($outOfStockItems)) : ?>
                        <p class="dashboard-empty-state"><?= lang('Dashboard.no_out_of_stock_items') ?></p>
                    <?php else : ?>
                        <div class="dashboard-table-wrapper">
                        <table class="table table-striped table-condensed table-bordered dashboard-table">
                            <thead>
                                <tr>
                                    <th><?= lang('Reports.item_name') ?></th>
                                    <th><?= lang('Reports.item_number') ?></th>
                                    <th><?= lang('Reports.stock_location') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($outOfStockItems as $o) : ?>
                                    <tr>
                                        <td><a href="<?= base_url('items/view/' . $o['item_id']) ?>"><?= esc($o['name']) ?></a></td>
                                        <td><?= esc($o['item_number']) ?></td>
                                        <td><?= esc($o['location_name']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Quick Access -->
    <section class="dashboard-section dashboard-modules">
        <h3 class="dashboard-section-title"><?= lang('Dashboard.quick_access') ?></h3>
        <div id="home_module_list">
            <?php
            $menu_categories = config(\Config\MenuCategories::class);
            foreach ($allowed_modules as $module) :
                $icon = $menu_categories->getMenuIcon($module->module_id);
            ?>
                <div class="module_item" title="<?= lang("Module.$module->module_id" . '_desc') ?>">
                    <a href="<?= base_url($module->module_id) ?>">
                        <?php if ($icon !== 'svg') : ?>
                            <span class="glyphicon glyphicon-<?= esc($icon) ?> module-item-icon" aria-hidden="true"></span>
                        <?php else : ?>
                            <img src="<?= base_url("images/menubar/$module->module_id.svg") ?>" alt="" class="module-item-icon">
                        <?php endif; ?>
                    </a>
                    <a href="<?= base_url($module->module_id) ?>"><?= lang("Module.$module->module_id") ?></a>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
</div>
</div>
</div>

<script type="text/javascript">
(function() {
    var salesSeries = <?= json_encode(array_map(function ($s) { return is_array($s) ? ($s['value'] ?? 0) : $s; }, $salesChart['series'] ?? [])) ?>;
    var salesData = {
        labels: <?= json_encode(esc($salesChart['labels'] ?? [], 'js')) ?>,
        series: [{
            name: '<?= esc(lang('Reports.revenue'), 'js') ?>',
            data: salesSeries
        }]
    };

    var pieData = {
        labels: <?= json_encode(esc($salesVsExpensesChart['labels'] ?? [], 'js')) ?>,
        series: <?= json_encode(esc($salesVsExpensesChart['series'] ?? [], 'js')) ?>
    };

    var currencySymbol = '<?= esc($config['currency_symbol'] ?? '', 'js') ?>';
    var currencyRight = <?= json_encode(is_right_side_currency_symbol()) ?>;

    function fmtCurrency(value) {
        return currencyRight ? value + currencySymbol : currencySymbol + value;
    }

    if (salesData.labels.length > 0) {
        new Chartist.Bar('#dashboard-sales-chart', salesData, {
            width: '100%',
            height: '250px',
            chartPadding: { top: 20, right: 20, bottom: 60, left: 60 },
            axisX: { offset: 60, position: 'end' },
            axisY: {
                offset: 50,
                labelInterpolationFnc: function(value) { return fmtCurrency(value); }
            },
            plugins: [
                Chartist.plugins.tooltip({
                    transformTooltipTextFnc: function(value) { return fmtCurrency(value); }
                }),
                Chartist.plugins.ctBarLabels()
            ]
        });
    }

    var pieTotal = (pieData.series[0] ? pieData.series[0].value : 0) + (pieData.series[1] ? pieData.series[1].value : 0);
    if (pieTotal > 0) {
        new Chartist.Pie('#dashboard-pie-chart', pieData, {
            width: '100%',
            height: '250px',
            chartPadding: 20,
            labelPosition: 'outside',
            plugins: [
                Chartist.plugins.tooltip({
                    transformTooltipTextFnc: function(value) { return fmtCurrency(value); }
                })
            ]
        });
    } else {
        document.getElementById('dashboard-pie-chart').innerHTML = '<p class="text-muted dashboard-chart-empty"><?= esc(lang('Dashboard.chart_no_data'), 'js') ?></p>';
    }
})();
</script>

<?= view('partial/footer') ?>
