<?php
/**
 * @var object $item_info
 * @var array $stock_locations
 * @var array $item_quantities
 * @var array $received_batches
 */

use App\Models\Employee;
use App\Models\Inventory;
?>

<div id="count_details_content" class="modal-dialog-content" style="min-width: 420px; min-height: 200px; padding: 15px; overflow: auto;">
<?= form_open('items', ['id' => 'item_form', 'class' => 'form-horizontal']) ?>
    <fieldset id="count_item_basic_info">

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.item_number'), 'name', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <div class="input-group">
                    <span class="input-group-addon input-sm"><span class="glyphicon glyphicon-barcode"></span></span>
                    <?= form_input([
                        'name'     => 'item_number',
                        'id'       => 'item_number',
                        'class'    => 'form-control input-sm',
                        'disabled' => '',
                        'value'    => $item_info->item_number ?? ''
                    ]) ?>
                </div>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.name'), 'name', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?= form_input([
                    'name'     => 'name',
                    'id'       => 'name',
                    'class'    => 'form-control input-sm',
                    'disabled' => '',
                    'value'    => $item_info->name ?? ''
                ]) ?>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.category'), 'category', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <div class="input-group">
                    <span class="input-group-addon input-sm"><span class="glyphicon glyphicon-tag"></span></span>
                    <?= form_input([
                        'name'     => 'category',
                        'id'       => 'category',
                        'class'    => 'form-control input-sm',
                        'disabled' => '',
                        'value'    => $item_info->category ?? ''
                    ]) ?>
                </div>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.stock_location'), 'stock_location', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?php
                $first_loc_id = !empty($stock_locations) ? array_key_first($stock_locations) : null;
                $first_qty = $first_loc_id !== null && isset($item_quantities[$first_loc_id]) ? $item_quantities[$first_loc_id] : 0;
                $stock_locations_for_dropdown = $stock_locations ?: ['' => lang('Common.none')];
                ?>
                <?= form_dropdown('stock_location', $stock_locations_for_dropdown, (string) $first_loc_id, ['onchange' => 'display_stock(this.value);', 'class' => 'form-control']) ?>
            </div>
        </div>

        <div class="form-group form-group-sm">
            <?= form_label(lang('Items.current_quantity'), 'quantity', ['class' => 'control-label col-xs-3']) ?>
            <div class="col-xs-8">
                <?php
                $qp = quantity_to_carton_pieces((float) $first_qty, $item_info);
                ?>
                <?= form_input([
                    'name'     => 'quantity',
                    'id'       => 'quantity',
                    'class'    => 'form-control input-sm',
                    'disabled' => '',
                    'value'    => to_quantity_decimals($first_qty)
                ]) ?>
                <?php if ($qp['has_bulk']) : ?>
                    <small class="text-muted">(<?= to_quantity_decimals($qp['carton']) ?> <?= esc($qp['bulk_label']) ?> + <?= to_quantity_decimals($qp['pieces']) ?> <?= lang('Items.unit_piece') ?>)</small>
                <?php endif; ?>
            </div>
        </div>

    </fieldset>
<?= form_close() ?>

<table id="items_count_details" class="table table-striped table-hover">
    <thead>
        <tr style="background-color: #999 !important;">
            <th colspan="6"><?= lang('Items.inventory_data_tracking') ?></th>
        </tr>
        <tr>
            <th style="width: 25%;"><?= lang('Items.inventory_date') ?></th>
            <th style="width: 15%;"><?= lang('Items.inventory_employee') ?></th>
            <th style="width: 15%;"><?= lang('Items.inventory_in_out_quantity') ?></th>
            <th style="width: 12%;"><?= lang('Sales.carton_qty') ?></th>
            <th style="width: 12%;"><?= lang('Sales.pieces_qty') ?></th>
            <th style="width: 21%;"><?= lang('Items.inventory_remarks') ?></th>
        </tr>
    </thead>
    <tbody id="inventory_result">
        <?php
        $employee = model(Employee::class);
        $inventory = model(Inventory::class);
        $config = config(\Config\OSPOS::class)->settings;
        $date_format = $config['dateformat'] ?? 'm/d/Y';
        $time_format = $config['timeformat'] ?? 'H:i:s';

        $inventory_array = $inventory->get_inventory_data_for_item($item_info->item_id)->getResultArray();
        $employee_name = [];
        $inventory_carton_pieces = [];

        foreach ($inventory_array as $row) {
            $trans_user = (int) ($row['trans_user'] ?? 0);
            $emp = $trans_user > 0 ? $employee->get_info($trans_user) : (object) ['first_name' => '', 'last_name' => ''];
            $employee_name[] = ($emp->first_name ?? '') . ' ' . ($emp->last_name ?? '');
            $tq = (float) ($row['trans_inventory'] ?? 0);
            $tqp = quantity_to_carton_pieces($tq, $item_info);
            $inventory_carton_pieces[] = ['carton' => $tqp['carton'], 'pieces' => $tqp['pieces'], 'has_bulk' => $tqp['has_bulk']];
        }

        $show_loc_id = $first_loc_id ?? null;
        $has_rows = false;
        foreach ($inventory_array as $idx => $row) {
            if ($show_loc_id !== null && (int) ($row['trans_location'] ?? 0) !== (int) $show_loc_id) {
                continue;
            }
            $has_rows = true;
            $emp_name = $employee_name[$idx] ?? '';
            $trans_date = !empty($row['trans_date']) ? date($date_format . ' ' . $time_format, strtotime($row['trans_date'])) : '';
            ?>
        <?php
            $trans_qty = (float) ($row['trans_inventory'] ?? 0);
            $tqp = quantity_to_carton_pieces($trans_qty, $item_info);
        ?>
        <tr>
            <td><?= esc($trans_date) ?></td>
            <td><?= esc($emp_name) ?></td>
            <td style="text-align: center;"><?= to_quantity_decimals($trans_qty) ?></td>
            <td style="text-align: center;"><?= $tqp['has_bulk'] ? to_quantity_decimals($tqp['carton']) : '0' ?></td>
            <td style="text-align: center;"><?= $tqp['has_bulk'] ? to_quantity_decimals($tqp['pieces']) : to_quantity_decimals($trans_qty) ?></td>
            <td><?= esc($row['trans_comment'] ?? '') ?></td>
        </tr>
        <?php }
        if (!$has_rows) { ?>
        <tr>
            <td colspan="6" class="text-center"><?= lang('Common.none') ?></td>
        </tr>
        <?php } ?>
    </tbody>
</table>

<?php if (!empty($received_batches)) { ?>
<table id="items_received_batches" class="table table-striped table-hover" style="margin-top: 15px;">
    <thead>
        <tr style="background-color: #999 !important;">
            <th colspan="7"><?= lang('Items.received_batches') ?></th>
        </tr>
        <tr>
            <th style="width: 18%;"><?= lang('Receivings.id') ?></th>
            <th style="width: 18%;"><?= lang('Items.inventory_date') ?></th>
            <th style="width: 12%;"><?= lang('Reports.quantity') ?></th>
            <th style="width: 12%;"><?= lang('Sales.carton_qty') ?></th>
            <th style="width: 12%;"><?= lang('Sales.pieces_qty') ?></th>
            <th style="width: 14%;"><?= lang('Items.stock_location') ?></th>
            <th style="width: 14%;"><?= lang('Items.expire_date') ?></th>
        </tr>
    </thead>
    <tbody>
        <?php
        $config = config(\Config\OSPOS::class)->settings;
        $date_format = $config['dateformat'] ?? 'm/d/Y';
        foreach ($received_batches as $batch) {
            $loc_id = $batch['item_location'] ?? 0;
            $loc_name = $stock_locations[$loc_id] ?? $loc_id;
            $pieces = (float) ($batch['pieces_received'] ?? 0);
            $expire = $batch['expire_date'] ?? null;
            $bqp = quantity_to_carton_pieces($pieces, $item_info);
            ?>
        <tr>
            <td>RECV <?= (int) $batch['receiving_id'] ?></td>
            <td><?= esc($batch['receiving_time']) ?></td>
            <td style="text-align: center;"><?= to_quantity_decimals($pieces) ?></td>
            <td style="text-align: center;"><?= $bqp['has_bulk'] ? to_quantity_decimals($bqp['carton']) : '0' ?></td>
            <td style="text-align: center;"><?= $bqp['has_bulk'] ? to_quantity_decimals($bqp['pieces']) : to_quantity_decimals($pieces) ?></td>
            <td><?= esc($loc_name) ?></td>
            <td><?= $expire ? date($date_format, strtotime($expire)) : '&ndash;' ?></td>
        </tr>
        <?php } ?>
    </tbody>
</table>
<?php } ?>

</div>

<script type="text/javascript">
    $(document).ready(function() {
        var firstLocId = <?= json_encode($first_loc_id) ?>;
        if (firstLocId !== null) {
            display_stock(firstLocId);
        }
    });

    function display_stock(location_id) {
        var item_quantities = <?= json_encode($item_quantities ?? []) ?>;
        var qty = item_quantities[location_id] != null ? item_quantities[location_id] : (item_quantities[String(location_id)] != null ? item_quantities[String(location_id)] : 0);
        var qtyEl = document.getElementById("quantity");
        if (qtyEl) qtyEl.value = parseFloat(qty).toFixed(<?= quantity_decimals() ?>);

        var inventory_data = <?= json_encode($inventory_array ?? []) ?>;
        var employee_data = <?= json_encode($employee_name ?? []) ?>;
        var carton_pieces_data = <?= json_encode($inventory_carton_pieces ?? []) ?>;

        var table = document.getElementById("inventory_result");
        if (!table) return;

        // Remove old rows from tbody
        var rowCount = table.rows.length;
        for (var index = rowCount - 1; index >= 0; index--) {
            table.deleteRow(index);
        }

        // Add matching rows to tbody
        for (var index = 0; index < inventory_data.length; index++) {
            var data = inventory_data[index];
            var rowLoc = data['trans_location'];
            if (rowLoc == location_id || String(rowLoc) === String(location_id)) {
                var tr = document.createElement('tr');
                var cp = carton_pieces_data[index] || {};

                var td = document.createElement('td');
                td.appendChild(document.createTextNode(data['trans_date']));
                tr.appendChild(td);

                td = document.createElement('td');
                td.appendChild(document.createTextNode(employee_data[index]));
                tr.appendChild(td);

                td = document.createElement('td');
                td.style.textAlign = 'center';
                td.appendChild(document.createTextNode(parseFloat(data['trans_inventory']).toFixed(<?= quantity_decimals() ?>)));
                tr.appendChild(td);

                td = document.createElement('td');
                td.style.textAlign = 'center';
                td.appendChild(document.createTextNode(cp.has_bulk ? parseFloat(cp.carton).toFixed(<?= quantity_decimals() ?>) : '0'));
                tr.appendChild(td);

                td = document.createElement('td');
                td.style.textAlign = 'center';
                td.appendChild(document.createTextNode(cp.has_bulk ? parseFloat(cp.pieces).toFixed(<?= quantity_decimals() ?>) : parseFloat(data['trans_inventory']).toFixed(<?= quantity_decimals() ?>)));
                tr.appendChild(td);

                td = document.createElement('td');
                td.appendChild(document.createTextNode(data['trans_comment'] || ''));
                tr.appendChild(td);

                table.appendChild(tr);
            }
        }
        if (table.rows.length === 0) {
            var tr = document.createElement('tr');
            var td = document.createElement('td');
            td.colSpan = 6;
            td.className = 'text-center';
            td.textContent = <?= json_encode(lang('Common.none')) ?>;
            tr.appendChild(td);
            table.appendChild(tr);
        }
    }
</script>
