<?php
/**
 * @var array $config
 * @var string $theme
 * @var string $company
 * @var string $license_key
 * @var string|null $message
 * @var string|null $status
 * @var \App\Libraries\LicenseService $license_service
 */
$company = $company ?? 'GTS Point of Sale';
$theme   = $theme ?? 'flatly';
?>

<!doctype html>
<html lang="<?= current_language_code() ?>">

<head>
    <meta charset="utf-8">
    <base href="<?= base_url() ?>">
    <title><?= esc($company) . ' | ' . lang('License.activate_title') ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.ico">
    <link rel="stylesheet" href="resources/bootswatch5/<?= esc($theme) ?>/bootstrap.min.css">
    <link rel="stylesheet" href="css/login.css">
    <style>
        .license-modal { position: fixed; inset: 0; z-index: 1050; overflow-x: hidden; overflow-y: auto; background: rgba(0,0,0,.5); display: none; align-items: center; justify-content: center; }
        .license-modal.show { display: flex !important; }
        .license-modal-dialog { position: relative; width: 100%; max-width: 500px; margin: 1.75rem auto; }
        .license-modal-content { background: #fff; border-radius: 0.375rem; box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15); }
        .license-modal-header { display: flex; align-items: center; justify-content: space-between; padding: 1rem; border-bottom: 1px solid #dee2e6; }
        .license-modal-body { padding: 1rem; }
        .license-modal-footer { display: flex; justify-content: flex-end; padding: 0.75rem 1rem; border-top: 1px solid #dee2e6; gap: 0.5rem; }
        .license-modal .btn-close { cursor: pointer; opacity: .7; }
        .license-modal .btn-close:hover { opacity: 1; }
    </style>
    <meta name="theme-color" content="#2c3e50">
</head>

<body class="bg-secondary-subtle d-flex flex-column">
    <main class="d-flex justify-content-around align-items-center flex-grow-1">
        <div class="container-login container-fluid d-flex flex-column flex-md-row bg-body shadow rounded m-3 p-4 p-md-0">
            <div class="box-logo d-flex flex-column justify-content-center align-items-center border-end border-secondary-subtle px-4 pb-3 p-md-4">
                <?php if (isset($config['company_logo']) && ! empty($config['company_logo'])): ?>
                    <img class="logo w-100" src="<?= base_url('uploads/' . esc($config['company_logo'])) ?>" alt="<?= lang('Common.logo') . ' ' . esc($company) ?>">
                <?php else: ?>
                    <svg class="logo text-primary" role="img" viewBox="0 0 308.57998 308.57997" xmlns="http://www.w3.org/2000/svg">
                        <title><?= lang('Common.software_title') . ' ' . lang('Common.logo') ?></title>
                        <circle cx="154.28999" cy="154.28999" r="154.28999" fill="currentColor" />
                        <path fill="#fff" d="M154.88998 145.66999c-.03-1.26-.03-3.29.19-4.29 4.6-11.1 15.57-18.82 28.3-18.82h.41v58.3c0 .12-.03.78-.04.9-.54 16.46-14.01 29.7-30.59 29.7v27.08c21 0 39.17-11.27 49.29-28.07l.07-.11c2.9.45 5.86.75 8.9.75 31.95 0 57.81-26 57.81-57.81 0-30.87-24.37-56.46-55.1-57.81h-30.74c-17.18 0-32.61 7.64-43.22 19.63-10.59-11.92-25.86-19.59-43.02-19.59-31.86 0-57.77 25.91-57.77 57.77 0 31.86 25.91 57.77 57.77 57.77 31.86 0 57.77-25.91 57.77-57.77v-3.68c-.01.01-.02-3.31-.03-3.95zm-57.75 38.33c-16.92 0-30.69-13.77-30.69-30.69s13.77-30.69 30.69-30.69 30.69 13.77 30.69 30.69-13.77 30.69-30.69 30.69zm142.96-19.87c-4.33 11.64-15.57 19.9-28.7 19.9h-.54v-61.47h.54c13.13 0 24.37 8.26 28.7 19.9 1.35 3.25 2.03 6.91 2.03 10.83s-.67 7.59-2.03 10.84z" />
                    </svg>
                <?php endif; ?>
            </div>
            <section class="box-login d-flex flex-column justify-content-center align-items-center p-md-4">
                <h3 class="text-center m-0"><?= lang('License.activate') ?></h3>
                <p class="text-muted small text-center mt-2"><?= lang('License.license_key_help') ?></p>

                <?php if (session('license_success')): ?>
                    <div class="alert alert-success mt-3">
                        <?= esc(session('license_success')) ?>
                    </div>
                <?php endif; ?>

                <?php if (! empty($message)): ?>
                    <div class="alert alert-<?= in_array($status ?? '', ['expired', 'suspended'], true) ? 'warning' : 'danger' ?> mt-3">
                        <?= esc($message) ?>
                    </div>
                <?php endif; ?>

                <?= form_open('license/verify', ['id' => 'license_activate_form', 'class' => 'w-100']) ?>
                    <div class="form-floating mt-3">
                        <input class="form-control" id="license_key" name="license_key" type="text"
                               placeholder="<?= lang('License.license_key') ?>"
                               value="<?= esc(old('license_key', $license_key)) ?>"
                               required>
                        <label for="license_key"><?= lang('License.license_key') ?></label>
                    </div>
                    <div class="form-floating mt-3 mb-3">
                        <input class="form-control" id="secret_token" name="secret_token" type="text"
                               placeholder="<?= lang('License.secret_token') ?>"
                               value="<?= esc(old('secret_token', $license_service->getSecretToken())) ?>">
                        <label for="secret_token"><?= lang('License.secret_token') ?></label>
                        <div class="form-text small"><?= lang('License.secret_token_help') ?></div>
                    </div>
                    <div class="d-grid gap-2">
                        <button class="btn btn-lg btn-primary" type="submit" id="license_submit_btn"><?= lang('License.submit') ?></button>
                        <a class="btn btn-outline-secondary" href="<?= base_url('login') ?>"><?= lang('License.back_to_login') ?></a>
                    </div>
                <?= form_close() ?>

                <!-- Loading popup -->
                <div id="license_loading_modal" class="license-modal">
                    <div class="license-modal-dialog">
                        <div class="license-modal-content">
                            <div class="license-modal-body text-center py-4">
                                <div class="spinner-border text-primary mb-3" role="status"></div>
                                <p class="mb-0" id="license_loading_text"><?= lang('License.verifying') ?></p>
                                <button type="button" class="btn btn-sm btn-outline-secondary mt-3" id="license_loading_cancel"><?= lang('Common.close') ?></button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Result popup -->
                <div id="license_result_modal" class="license-modal">
                    <div class="license-modal-dialog" id="license_result_dialog">
                        <div class="license-modal-content">
                            <div class="license-modal-header" id="license_result_header">
                                <h5 class="license-modal-title" id="license_result_title"><?= lang('License.result') ?></h5>
                                <button type="button" class="btn-close" id="license_result_close" aria-label="Close"></button>
                            </div>
                            <div class="license-modal-body" id="license_result_body"></div>
                            <div class="license-modal-footer">
                                <button type="button" class="btn btn-primary" id="license_result_btn"><?= lang('Common.close') ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </main>

    <footer class="d-flex justify-content-center flex-shrink-0 text-center">
        <div class="footer container-fluid bg-body rounded shadow p-3 mb-md-4 mx-md-3">
            <span class="text-primary">
                <svg height="1.25em" role="img" viewBox="0 0 308.57998 308.57997" xmlns="http://www.w3.org/2000/svg">
                    <title><?= lang('Common.software_title') . ' ' . lang('Common.logo') ?></title>
                    <circle cx="154.28999" cy="154.28999" r="154.28999" fill="currentColor" />
                    <path fill="#fff" d="M154.88998 145.66999c-.03-1.26-.03-3.29.19-4.29 4.6-11.1 15.57-18.82 28.3-18.82h.41v58.3c0 .12-.03.78-.04.9-.54 16.46-14.01 29.7-30.59 29.7v27.08c21 0 39.17-11.27 49.29-28.07l.07-.11c2.9.45 5.86.75 8.9.75 31.95 0 57.81-26 57.81-57.81 0-30.87-24.37-56.46-55.1-57.81h-30.74c-17.18 0-32.61 7.64-43.22 19.63-10.59-11.92-25.86-19.59-43.02-19.59-31.86 0-57.77 25.91-57.77 57.77 0 31.86 25.91 57.77 57.77 57.77 31.86 0 57.77-25.91 57.77-57.77v-3.68c-.01.01-.02-3.31-.03-3.95zm-57.75 38.33c-16.92 0-30.69-13.77-30.69-30.69s13.77-30.69 30.69-30.69 30.69 13.77 30.69 30.69-13.77 30.69-30.69 30.69zm142.96-19.87c-4.33 11.64-15.57 19.9-28.7 19.9h-.54v-61.47h.54c13.13 0 24.37 8.26 28.7 19.9 1.35 3.25 2.03 6.91 2.03 10.83s-.67 7.59-2.03 10.84z" />
                </svg>
            </span>
            <span><?= lang('Common.software_title') ?></span>
        </div>
    </footer>

    <script>
    (function() {
        var form = document.getElementById('license_activate_form');
        var submitBtn = document.getElementById('license_submit_btn');
        var loadingModal = document.getElementById('license_loading_modal');
        var resultModal = document.getElementById('license_result_modal');
        var resultDialog = document.getElementById('license_result_dialog');
        var resultBody = document.getElementById('license_result_body');
        var resultTitle = document.getElementById('license_result_title');
        var resultHeader = document.getElementById('license_result_header');
        var resultBtn = document.getElementById('license_result_btn');
        var resultClose = document.getElementById('license_result_close');
        var loadingCancel = document.getElementById('license_loading_cancel');
        var baseUrl = document.querySelector('base') ? document.querySelector('base').href : '';
        var abortController = null;

        function showLoading() {
            submitBtn.disabled = true;
            loadingModal.classList.add('show');
        }

        function hideLoading() {
            submitBtn.disabled = false;
            loadingModal.classList.remove('show');
        }

        function closeResult(redirectUrl) {
            resultModal.classList.remove('show');
            if (redirectUrl) {
                window.location.href = redirectUrl;
            }
        }

        function showResult(success, message, redirectUrl) {
            resultBody.textContent = message;
            resultTitle.textContent = success ? '<?= lang('License.success') ?>' : '<?= lang('License.result') ?>';
            resultHeader.className = 'license-modal-header ' + (success ? 'text-success' : 'text-danger');
            resultHeader.style.borderBottomColor = success ? '#198754' : '#dc3545';
            resultModal.classList.add('show');

            resultBtn.textContent = success ? '<?= lang('License.continue') ?>' : '<?= lang('Common.close') ?>';
            resultBtn.onclick = function() { closeResult(success ? redirectUrl : null); };
            resultClose.onclick = function() { closeResult(success ? redirectUrl : null); };

            resultModal.onclick = function(e) {
                if (e.target === resultModal) { closeResult(success ? redirectUrl : null); }
            };
            resultDialog.onclick = function(e) { e.stopPropagation(); };
        }

        loadingCancel.onclick = function() {
            if (abortController) abortController.abort();
            hideLoading();
        };

        form.addEventListener('submit', function(e) {
            e.preventDefault();
            showLoading();
            abortController = new AbortController();

            var formData = new FormData(form);
            var verifyUrl = baseUrl + (baseUrl.endsWith('/') ? '' : '/') + 'license/verify';

            fetch(verifyUrl, {
                method: 'POST',
                body: formData,
                headers: { 'X-Requested-With': 'XMLHttpRequest' },
                signal: abortController.signal
            })
            .then(function(r) {
                if (!r.ok) throw new Error('Request failed');
                return r.json();
            })
            .then(function(data) {
                hideLoading();
                if (data.success) {
                    showResult(true, data.message || '<?= lang('License.success') ?>', data.redirect || baseUrl + 'login');
                } else {
                    showResult(false, data.message || '<?= lang('License.invalid') ?>');
                }
            })
            .catch(function(err) {
                hideLoading();
                if (err.name !== 'AbortError') {
                    showResult(false, '<?= lang('License.error_network') ?>');
                }
            });
        });
    })();
    </script>
</body>

</html>
