<?php
/**
 * @var string $controller_name
 * @var string $table_headers
 * @var array $config
 * @var int $employee_id
 */
?>

<?= view('partial/header') ?>
<link rel="stylesheet" href="<?= base_url('css/manage-pages.css') ?>" media="all">

<script type="text/javascript">
    $(document).ready(function() {
        <?= view('partial/bootstrap_tables_locale') ?>

        table_support.init({
            employee_id: <?= (int) ($employee_id ?? 0) ?>,
            resource: '<?= esc($controller_name) ?>',
            headers: <?= $table_headers ?>,
            pageSize: <?= $config['lines_per_page'] ?>,
            uniqueId: 'people.person_id',
            enableActions: function() {
                var email_disabled = $("td input:checkbox:checked").parents("tr").find("td a[href^='mailto:']").length == 0;
                $("#email").prop('disabled', email_disabled);
            }
        });

        $("#email").click(function(event) {
            var recipients = $.map($("tr.selected a[href^='mailto:']"), function(element) {
                return $(element).attr('href').replace(/^mailto:/, '');
            });
            location.href = "mailto:" + recipients.join(",");
        });
    });
</script>

<div class="col-xs-12">
<div class="manage-page manage-page--<?= esc($controller_name) ?>">
    <div class="manage-page-header">
        <h2 class="manage-page-title"><?= lang('Module.' . $controller_name) ?></h2>
        <div class="manage-page-actions print_hide">
            <?php if ($controller_name === 'customers') : ?>
                <button class="btn btn-info btn-sm modal-dlg" data-btn-submit="<?= lang('Common.submit') ?>" data-href="<?= "$controller_name/csvImport" ?>" title="<?= lang(ucfirst($controller_name) . '.import_items_csv') ?>">
                    <span class="glyphicon glyphicon-import"></span> <?= lang('Common.import_csv') ?>
                </button>
            <?php endif; ?>
            <button class="btn btn-info btn-sm modal-dlg" data-btn-submit="<?= lang('Common.submit') ?>" data-href="<?= "$controller_name/view" ?>" title="<?= lang(ucfirst($controller_name) . '.new') ?>">
                <span class="glyphicon glyphicon-user"></span> <?= lang(ucfirst($controller_name) . '.new') ?>
            </button>
        </div>
    </div>

    <div id="title_bar" class="print_hide" style="display:none;"></div>

    <div id="toolbar" class="manage-toolbar-card">
        <div class="pull-left btn-toolbar">
            <button id="delete" class="btn btn-default btn-sm">
                <span class="glyphicon glyphicon-trash"></span> <?= lang('Common.delete') ?>
            </button>
            <button id="email" class="btn btn-default btn-sm">
                <span class="glyphicon glyphicon-envelope"></span> <?= lang('Common.email') ?>
            </button>
        </div>
    </div>

    <div id="table_holder" class="manage-table-card">
        <table id="table"></table>
    </div>
</div>
</div>

<?= view('partial/footer') ?>
