<?php
/**
 * @var string $controller_name
 * @var array $modes
 * @var string $mode
 * @var bool $show_stock_locations
 * @var array $stock_locations
 * @var int $stock_source
 * @var string $stock_destination
 * @var array $cart
 * @var bool $items_module_allowed
 * @var float $total
 * @var string $comment
 * @var bool $print_after_sale
 * @var string $reference
 * @var array $payment_options
 * @var string $payment_type
 * @var int $editing_receiving_id
 * @var array $config
 */
?>

<?= view('partial/header') ?>
<link rel="stylesheet" href="<?= base_url('css/register-pages.css') ?>" media="all">

<style>
#register_wrapper .table-responsive { margin-bottom: 0.5em; }
#register th, #register td { text-align: center !important; }
#register .input-group { display: inline-block; margin: 0 auto; }
#register tbody tr:hover { background-color: #f5f5f5; }
#register .description-row:hover { background-color: transparent !important; }
#overall_sale .table { margin-bottom: 0.5em; }
#overall_sale #sale_totals { margin-top: 0.8em; }
#payment_details { margin-top: 1em; padding-top: 0.5em; border-top: 1px solid #ddd; }
#payment_details .table { margin-bottom: 0; }
</style>

<?php
if (isset($error)) {
    echo '<div class="alert alert-dismissible alert-danger">' . esc($error) . '</div>';
}

if (!empty($warning)) {
    echo '<div class="alert alert-dismissible alert-warning">' . esc($warning) . '</div>';
}

if (isset($success)) {
    echo '<div class="alert alert-dismissible alert-success">' .esc($success) . '</div>';
}
?>

<div class="col-xs-12 register-page register-page--receivings">
<div id="register_wrapper">

    <?php if (!empty($editing_receiving_id) && $editing_receiving_id > 0) { ?>
        <div class="alert alert-info">
            <strong><?= lang('Receivings.editing_receiving') ?></strong> RECV <?= (int) $editing_receiving_id ?>
        </div>
    <?php } ?>

    <!-- Top register controls -->

    <?= form_open("$controller_name/changeMode", ['id' => 'mode_form', 'class' => 'form-horizontal panel panel-default']) ?>

    <div class="panel-body form-group">
        <ul>
            <li class="pull-left first_li">
                <label class="control-label"><?= lang(ucfirst($controller_name) . '.mode') ?></label>
            </li>
            <li class="pull-left">
                <?= form_dropdown('mode', $modes, $mode, ['onchange' => "$('#mode_form').submit();", 'class' => 'selectpicker show-menu-arrow', 'data-style' => 'btn-default btn-sm', 'data-width' => 'fit']) ?>
            </li>

            <?php if ($show_stock_locations) { ?>
                <li class="pull-left">
                    <label class="control-label"><?= lang(ucfirst($controller_name) . '.stock_source') ?></label>
                </li>
                <li class="pull-left">
                    <?= form_dropdown('stock_source', $stock_locations, $stock_source, ['onchange' => "$('#mode_form').submit();", 'class' => 'selectpicker show-menu-arrow', 'data-style' => 'btn-default btn-sm', 'data-width' => 'fit']) ?>
                </li>

                <?php if ($mode == 'requisition') { ?>
                    <li class="pull-left">
                        <label class="control-label"><?= lang(ucfirst($controller_name) . '.stock_destination') ?></label>
                    </li>
                    <li class="pull-left">
                        <?= form_dropdown('stock_destination', $stock_locations, $stock_destination, ['onchange' => "$('#mode_form').submit();", 'class' => 'selectpicker show-menu-arrow', 'data-style' => 'btn-default btn-sm', 'data-width' => 'fit']) ?>
                    </li>
            <?php
                }
            }
            ?>
                <?php if (model(\App\Models\Employee::class)->has_grant('reports_receivings', session('person_id'))) { ?>
                <li class="pull-right">
                    <?= anchor("$controller_name/manage", '<span class="glyphicon glyphicon-list-alt">&nbsp;</span>' . lang('Receivings.daily_receivings'), ['class' => 'btn btn-primary btn-sm', 'id' => 'receivings_takings_button', 'title' => lang('Receivings.daily_receivings')]) ?>
                </li>
                <?php } ?>
        </ul>
    </div>

    <?= form_close() ?>

    <?= form_open("$controller_name/add", ['id' => 'add_item_form', 'class' => 'form-horizontal panel panel-default']) ?>

    <div class="panel-body form-group">
        <ul>
            <li class="pull-left first_li">
                <label for="item" class="control-label">
                    <?php if ($mode == 'receive' or $mode == 'requisition') { ?>
                        <?= lang(ucfirst($controller_name) . '.find_or_scan_item') ?>
                    <?php } else { ?>
                        <?= lang(ucfirst($controller_name) . '.find_or_scan_item_or_receipt') ?>
                    <?php } ?>
                </label>
            </li>

            <li class="pull-left">
                <?= form_input(['name' => 'item', 'id' => 'item', 'class' => 'form-control input-sm', 'size' => '50', 'tabindex' => '1']) ?>
            </li>

            <li class="pull-right">
                <button id="new_item_button" class="btn btn-info btn-sm pull-right modal-dlg" data-btn-submit="<?= lang('Common.submit') ?>" data-btn-new="<?= lang('Common.new') ?>" data-href="<?= "items/view" ?>" title="<?= lang('Sales.new_item') ?>">
                    <span class="glyphicon glyphicon-tag">&nbsp;</span><?= lang('Sales.new_item') ?>
                </button>
            </li>
        </ul>
    </div>

    <?= form_close() ?>

    <!-- Receiving Items List -->

    <div class="table-responsive register-table-card">
    <table class="table table-bordered table-condensed sales_table_100" id="register">
        <thead>
            <tr class="active">
                <th style="width: 4%; min-width: 40px;"><?= lang('Common.delete') ?></th>
                <th style="width: 10%; min-width: 80px;"><?= lang('Sales.item_number') ?></th>
                <th style="width: 24%; min-width: 150px;"><?= lang(ucfirst($controller_name) . '.item_name') ?></th>
                <th style="width: 10%; min-width: 70px;"><?= lang(ucfirst($controller_name) . '.cost') ?></th>
                <th style="width: 6%; min-width: 55px;"><?= lang('Sales.bulk_qty') ?></th>
                <th style="width: 6%; min-width: 55px;"><?= lang('Sales.pieces_qty') ?></th>
                <th style="width: 10%; min-width: 80px;"><?= lang(ucfirst($controller_name) . '.discount') ?></th>
                <th style="width: 8%; min-width: 70px;"><?= lang('Items.batch_number') ?></th>
                <th style="width: 10%; min-width: 90px;"><?= lang('Items.expire_date') ?></th>
                <th style="width: 10%; min-width: 75px;"><?= lang(ucfirst($controller_name) . '.total') ?></th>
                <th style="width: 4%; min-width: 40px;"><?= lang(ucfirst($controller_name) . '.update') ?></th>
            </tr>
        </thead>

        <tbody id="cart_contents">
            <?php if (count($cart) == 0) { ?>
                <tr>
                    <td colspan="11">
                        <div class="alert alert-dismissible alert-info"><?= lang('Sales.no_items_in_cart') ?></div>
                    </td>
                </tr>
                <?php
            } else {
                foreach (array_reverse($cart, true) as $line => $item) {
                ?>

                    <?= form_open("$controller_name/editItem/$line", ['class' => 'form-horizontal', 'id' => "cart_$line"]) ?>

                    <tr>
                        <td style="vertical-align: middle;"><?= anchor("$controller_name/deleteItem/$line", '<span class="glyphicon glyphicon-trash"></span>', ['class' => 'btn btn-default btn-xs', 'title' => lang('Common.delete')]) ?></td>
                        <td style="vertical-align: middle;"><?= esc($item['item_number']) ?></td>
                        <td style="vertical-align: middle;">
                            <?php if (!empty($item['pic_filename'])): ?>
                                <img src="<?= esc(site_url('items/getPicThumb/' . rawurlencode($item['pic_filename']))) ?>" alt="" class="img-thumbnail" style="max-height: 40px; max-width: 50px; float: left; margin-right: 6px;">
                            <?php endif; ?>
                            <?= esc($item['name'] . ' ' . implode(' ', [$item['attribute_values'], $item['attribute_dtvalues']])) ?><br>
                            <?= '[' . to_quantity_decimals($item['in_stock']) . ' in ' . $item['stock_name'] . ']' ?>
                            <?= form_hidden('location', (string)$item['item_location']) ?>
                        </td>

                        <?php if ($items_module_allowed && $mode != 'requisition') { ?>
                            <td style="vertical-align: middle;">
                                <?php
                                $receiving_qty = (float) ($item['receiving_quantity'] ?? 1);
                                $cost_val = $receiving_qty > 1
                                    ? ($item['unit_price_bulk'] ?? ($item['price'] * $receiving_qty))
                                    : ($item['price'] ?? 0);
                                echo form_input([
                                    'name'    => 'price',
                                    'class'   => 'form-control input-sm',
                                    'value'   => to_currency_no_money($cost_val),
                                    'onClick' => 'this.select();'
                                ]);
                                if ($receiving_qty > 1 && !empty($item['bulk_label'])) {
                                    $cost_per_piece = isset($item['price_per_piece']) ? $item['price_per_piece'] : ($receiving_qty > 0 ? (float) bcdiv((string) $cost_val, (string) $receiving_qty, 6) : $cost_val);
                                    echo '<br><small class="text-muted">' . to_currency($cost_per_piece) . '/pc</small>';
                                }
                                ?>
                            </td>
                        <?php } else { ?>
                            <td style="vertical-align: middle;">
                                <?php
                                $receiving_qty = (float) ($item['receiving_quantity'] ?? 1);
                                if ($receiving_qty > 1 && isset($item['unit_price_bulk'])) {
                                    echo to_currency($item['unit_price_bulk']) . '<br><small class="text-muted">(' . to_currency($item['price_per_piece'] ?? $item['price']) . '/pc)</small>';
                                    echo form_hidden('price', to_currency_no_money($item['unit_price_bulk']));
                                } else {
                                    echo to_currency($item['price']);
                                    echo form_hidden('price', to_currency_no_money($item['price']));
                                }
                                ?>
                            </td>
                        <?php } ?>

                        <td style="vertical-align: middle;">
                            <?php
                            $receiving_qty = (float) ($item['receiving_quantity'] ?? 1);
                            if ($receiving_qty > 1) {
                                $qty_carton = $item['qty_carton'] ?? $item['quantity'] ?? 0;
                                echo form_input(['name' => 'qty_carton', 'class' => 'form-control input-sm text-center', 'value' => to_quantity_decimals($qty_carton), 'onClick' => 'this.select();', 'style' => 'max-width: 55px; margin: 0 auto;', 'placeholder' => '0']);
                            } else {
                                echo '&ndash;';
                            }
                            ?>
                        </td>
                        <td style="vertical-align: middle;">
                            <?php
                            $receiving_qty = (float) ($item['receiving_quantity'] ?? 1);
                            if ($receiving_qty > 1) {
                                $qty_piece = $item['qty_piece'] ?? '0';
                                echo form_input(['name' => 'qty_piece', 'class' => 'form-control input-sm text-center', 'value' => to_quantity_decimals($qty_piece), 'onClick' => 'this.select();', 'style' => 'max-width: 55px; margin: 0 auto;', 'placeholder' => '0']);
                            } else {
                                echo form_input(['name' => 'quantity', 'class' => 'form-control input-sm text-center', 'value' => to_quantity_decimals($item['quantity']), 'onClick' => 'this.select();', 'style' => 'max-width: 55px; margin: 0 auto;']);
                            }
                            ?>
                        </td>
                        <?= form_hidden('receiving_quantity', (string)($item['receiving_quantity'] ?? 1)) ?>

                        <?php if ($items_module_allowed && $mode != 'requisition') { ?>
                            <td style="vertical-align: middle;">
                                <div class="input-group input-group-sm">
                                    <?= form_input(['name' => 'discount', 'class' => 'form-control input-sm', 'value' => $item['discount_type'] ? to_currency_no_money($item['discount']) : to_decimals($item['discount']), 'onClick' => 'this.select();']) ?>
                                    <span class="input-group-btn">
                                        <?= form_checkbox([
                                            'id'           => 'discount_toggle',
                                            'name'         => 'discount_toggle',
                                            'value'        => 1,
                                            'data-toggle'  => "toggle",
                                            'data-size'    => 'small',
                                            'data-onstyle' => 'success',
                                            'data-on'      => '<b>' . $config['currency_symbol'] . '</b>',
                                            'data-off'     => '<b>%</b>',
                                            'data-line'    => $line,
                                            'checked'      => $item['discount_type'] == 1
                                        ]) ?>
                                    </span>
                                </div>
                            </td>
                        <?php } else { ?>
                            <td style="vertical-align: middle;"><?= $item['discount'] ?></td>
                            <?= form_hidden('discount', (string)$item['discount']) ?>
                        <?php } ?>
                        <td style="vertical-align: middle;">
                            <?= form_input([
                                'name'  => 'batch_number',
                                'class' => 'form-control input-sm',
                                'value' => $item['batch_number'] ?? '',
                                'placeholder' => lang('Items.batch_number'),
                                'style' => 'min-width: 70px;'
                            ]) ?>
                        </td>
                        <td style="vertical-align: middle;">
                            <?= form_input([
                                'name'  => 'expire_date',
                                'type'  => 'date',
                                'class' => 'form-control input-sm',
                                'value' => isset($item['expire_date']) && $item['expire_date'] !== '' ? $item['expire_date'] : '',
                                'style' => 'min-width: 120px;'
                            ]) ?>
                        </td>
                        <td style="vertical-align: middle; font-weight: bold;">
                            <?= to_currency($item['total']) ?>
                        </td>
                        <td style="vertical-align: middle;">
                            <a href="javascript:$('#<?= esc("cart_$line", 'js') ?>').submit();" class="btn btn-default btn-xs" title="<?= lang(ucfirst($controller_name) . '.update') ?>">
                                <span class="glyphicon glyphicon-refresh"></span>
                            </a>
                        </td>
                    </tr>
                    <tr class="description-row">
                        <?php if ($item['allow_alt_description'] == 1) {    // TODO: ===?
                        ?>
                            <td style="color: #2F4F4F; vertical-align: middle;"><?= lang('Sales.description_abbrv') . ':' ?></td>
                        <?php } ?>
                        <td colspan="2" style="vertical-align: middle;">
                            <?php
                            if ($item['allow_alt_description'] == 1) {    // TODO: ===?
                                echo form_input([
                                    'name'  => 'description',
                                    'class' => 'form-control input-sm',
                                    'value' => $item['description']
                                ]);
                            } else {
                                if ($item['description'] != '') {    // TODO: !==?
                                    echo $item['description'];
                                    echo form_hidden('description', $item['description']);
                                } else {
                                    echo '<i>' . lang('Sales.no_description') . '</i>';
                                    echo form_hidden('description', '');
                                }
                            }
                            ?>
                        </td>
                        <td colspan="8" style="background: #f9f9f9;"></td>
                    </tr>

                    <?= form_close() ?>

            <?php
                }
            }
            ?>
        </tbody>
    </table>
    </div>
</div>

<!-- Overall Receiving -->

<div id="overall_sale" class="panel panel-default">
    <div class="panel-body">
        <?php if (isset($supplier)) { ?>

            <table class="table table-condensed sales_table_100">
                <tbody>
                <tr>
                    <td class="text-muted" style="width: 40%;"><?= lang(ucfirst($controller_name) . '.supplier') ?></td>
                    <td style="text-align: right; width: 60%;"><?= esc($supplier) ?></td>
                </tr>
                <?php if (!empty($supplier_email)) { ?>
                    <tr>
                        <td class="text-muted"><?= lang(ucfirst($controller_name) . '.supplier_email') ?></td>
                        <td style="text-align: right;"><?= esc($supplier_email) ?></td>
                    </tr>
                <?php } ?>
                <?php if (!empty($supplier_address)) { ?>
                    <tr>
                        <td class="text-muted"><?= lang(ucfirst($controller_name) . '.supplier_address') ?></td>
                        <td style="text-align: right;"><?= esc($supplier_address) ?></td>
                    </tr>
                <?php } ?>
                <?php if (!empty($supplier_location)) { ?>
                    <tr>
                        <td class="text-muted"><?= lang(ucfirst($controller_name) . '.supplier_location') ?></td>
                        <td style="text-align: right;"><?= esc($supplier_location) ?></td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>

            <?= anchor(
                "$controller_name/removeSupplier",
                '<span class="glyphicon glyphicon-remove">&nbsp;</span>' . lang('Common.remove') . ' ' . lang('Suppliers.supplier'),
                [
                    'class' => 'btn btn-danger btn-sm',
                    'id'    => 'remove_supplier_button',
                    'title' => lang('Common.remove') . ' ' . lang('Suppliers.supplier')
                ]
            ) ?>

        <?php } else { ?>

            <?= form_open("$controller_name/selectSupplier", ['id' => 'select_supplier_form', 'class' => 'form-horizontal']) ?>

            <div class="form-group" id="select_customer">
                <label id="supplier_label" for="supplier" class="control-label" style="margin-bottom: 1em; margin-top: -1em;">
                    <?= lang(ucfirst($controller_name) . '.select_supplier') ?>
                </label>
                <?= form_input([
                    'name'  => 'supplier',
                    'id'    => 'supplier',
                    'class' => 'form-control input-sm',
                    'value' => lang(ucfirst($controller_name) . '.start_typing_supplier_name')
                ]) ?>

                <button id="new_supplier_button" class="btn btn-info btn-sm modal-dlg" data-btn-submit="<?= lang('Common.submit') ?>" data-href="<?= "suppliers/view" ?>" title="<?= lang(ucfirst($controller_name) . '.new_supplier') ?>">
                    <span class="glyphicon glyphicon-user">&nbsp;</span><?= lang(ucfirst($controller_name) . '.new_supplier') ?>
                </button>

            </div>

            <?= form_close() ?>

        <?php } ?>

        <table class="table table-condensed sales_table_100" id="sale_totals">
            <tr class="info">
                <?php if ($mode != 'requisition') { ?>
                    <td style="width: 40%; font-weight: bold;"><?= lang('Sales.total') ?></td>
                    <td style="width: 60%; text-align: right; font-weight: bold; font-size: 1.1em;"><?= to_currency($total) ?></td>
                <?php } else { ?>
                    <td style="width: 40%;"></td>
                    <td style="width: 60%; text-align: right;"></td>
                <?php } ?>
            </tr>
        </table>

        <?php if (count($cart) > 0) { ?>
            <div id="finish_sale">
                <?php if ($mode == 'requisition') { ?>

                    <?= form_open("$controller_name/requisitionComplete", ['id' => 'finish_receiving_form', 'class' => 'form-horizontal']) ?>

                    <div class="form-group form-group-sm">
                        <label id="comment_label" for="comment"><?= lang('Common.comments') ?></label>
                        <?= form_textarea([
                            'name'  => 'comment',
                            'id'    => 'comment',
                            'class' => 'form-control input-sm',
                            'value' => $comment,
                            'rows'  => '4'
                        ]) ?>

                        <div class="btn btn-sm btn-danger pull-left" id="cancel_receiving_button">
                            <span class="glyphicon glyphicon-remove">&nbsp;</span><?= lang(ucfirst($controller_name) . '.cancel_receiving') ?>
                        </div>
                        <div class="btn btn-sm btn-success pull-right" id="finish_receiving_button">
                            <span class="glyphicon glyphicon-ok">&nbsp;</span><?= lang(ucfirst($controller_name) . '.complete_receiving') ?>
                        </div>
                    </div>

                    <?= form_close() ?>

                <?php } else { ?>

                    <?= form_open("$controller_name/complete", ['id' => 'finish_receiving_form', 'class' => 'form-horizontal']) ?>

                    <div class="form-group form-group-sm">
                        <label id="comment_label" for="comment"><?= lang('Common.comments') ?></label>
                        <?= form_textarea([
                            'name'  => 'comment',
                            'id'    => 'comment',
                            'class' => 'form-control input-sm',
                            'value' => $comment,
                            'rows'  => '4'
                        ]) ?>
                        <div id="payment_details">
                            <table class="table table-condensed">
                                <tbody>
                                <tr>
                                    <td style="width: 45%;" class="text-muted"><?= lang(ucfirst($controller_name) . '.print_after_sale') ?></td>
                                    <td style="width: 55%;"><?= form_checkbox([
                                        'name'    => 'recv_print_after_sale',
                                        'id'      => 'recv_print_after_sale',
                                        'class'   => 'checkbox',
                                        'value'   => 1,
                                        'checked' => $print_after_sale == 1
                                    ]) ?></td>
                                </tr>
                                <?php if ($mode == "receive") { ?>
                                    <tr>
                                        <td class="text-muted"><?= lang(ucfirst($controller_name) . '.reference') ?></td>
                                        <td><?= form_input([
                                            'name'  => 'recv_reference',
                                            'id'    => 'recv_reference',
                                            'class' => 'form-control input-sm',
                                            'value' => $reference,
                                            'size'  => 5
                                        ]) ?></td>
                                    </tr>
                                <?php } ?>
                                <tr>
                                    <td class="text-muted"><?= lang('Sales.payment') ?></td>
                                    <td><?= form_dropdown(
                                        'payment_type',
                                        $payment_options,
                                        $payment_type ?? '',
                                        [
                                            'id'         => 'recv_payment_types',
                                            'class'      => 'selectpicker show-menu-arrow',
                                            'data-style' => 'btn-default btn-sm',
                                            'data-width' => 'auto'
                                        ]
                                    ) ?></td>
                                </tr>
                                <tr id="recv_payment_reference_row" style="display: none;">
                                    <td class="text-muted"><?= lang('Sales.payment_reference') ?></td>
                                    <td><?= form_input([
                                        'name'  => 'payment_reference',
                                        'id'    => 'recv_payment_reference',
                                        'class' => 'form-control input-sm',
                                        'value' => $payment_reference ?? '',
                                        'placeholder' => lang('Sales.payment_reference_placeholder'),
                                        'maxlength' => 100
                                    ]) ?></td>
                                </tr>
                                <tr id="recv_due_date_row" style="display: none;">
                                    <td class="text-muted"><?= lang('Sales.due_date') ?></td>
                                    <td><?= form_input([
                                        'name'  => 'due_date',
                                        'id'    => 'recv_due_date',
                                        'type'  => 'date',
                                        'value' => $due_date ?? '',
                                        'class' => 'form-control input-sm'
                                    ]) ?></td>
                                </tr>
                                <tr>
                                    <td class="text-muted"><?= lang('Sales.amount_tendered') ?></td>
                                    <td><?= form_input([
                                        'name'  => 'amount_tendered',
                                        'value' => '',
                                        'class' => 'form-control input-sm',
                                        'size'  => '5'
                                    ]) ?></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="btn btn-sm btn-danger pull-left" id="cancel_receiving_button">
                            <span class="glyphicon glyphicon-remove">&nbsp;</span><?= lang(ucfirst($controller_name) . '.cancel_receiving') ?>
                        </div>
                        <div class="btn btn-sm btn-success pull-right" id="finish_receiving_button">
                            <span class="glyphicon glyphicon-ok">&nbsp;</span><?= lang(ucfirst($controller_name) . '.complete_receiving') ?>
                        </div>
                    </div>

                    <?= form_close() ?>

                <?php } ?>
            </div>
        <?php } ?>
    </div>
</div>
</div>

<div class="clearfix"></div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#item").autocomplete({
            source: '<?= esc("$controller_name/stockItemSearch") ?>',
            minChars: 0,
            delay: 10,
            autoFocus: false,
            select: function(a, ui) {
                $(this).val(ui.item.value);
                $("#add_item_form").submit();
                return false;
            }
        });

        $('#item').focus();

        $('#item').keypress(function(e) {
            if (e.which == 13) {
                $('#add_item_form').submit();
                return false;
            }
        });

        $('#item').blur(function() {
            $(this).attr('value', "<?= lang('Sales.start_typing_item_name') ?>");
        });

        $('#comment').keyup(function() {
            $.post('<?= esc("$controller_name/setComment") ?>', {
                comment: $('#comment').val()
            });
        });

        $('#recv_reference').keyup(function() {
            $.post('<?= esc("$controller_name/setReference") ?>', {
                recv_reference: $('#recv_reference').val()
            });
        });

        $("#recv_print_after_sale").change(function() {
            $.post('<?= esc("$controller_name/setPrintAfterSale") ?>', {
                recv_print_after_sale: $(this).is(":checked")
            });
        });

        function check_recv_payment_type() {
            var pt = $("#recv_payment_types").val();
            var needsRef = <?= json_encode(get_payment_methods_requiring_reference()) ?>;
            var needsDue = <?= json_encode(get_payment_methods_requiring_due_date()) ?>;
            $('#recv_payment_reference_row').toggle(needsRef.indexOf(pt) >= 0);
            $('#recv_due_date_row').toggle(needsDue.indexOf(pt) >= 0);
            if (needsRef.indexOf(pt) < 0) $('#recv_payment_reference').val('');
            if (needsDue.indexOf(pt) < 0) $('#recv_due_date').val('');
        }
        $('#recv_payment_types').change(check_recv_payment_type);
        check_recv_payment_type();

        $('#item,#supplier').click(function() {
            $(this).attr('value', '');
        });

        $("#supplier").autocomplete({
            source: '<?= "suppliers/suggest" ?>',
            minChars: 0,
            delay: 10,
            select: function(a, ui) {
                $(this).val(ui.item.value);
                $("#select_supplier_form").submit();
            }
        });

        dialog_support.init("a.modal-dlg, button.modal-dlg");

        $('#supplier').blur(function() {
            $(this).attr('value', "<?= lang(ucfirst($controller_name) . '.start_typing_supplier_name') ?>");
        });

        $("#finish_receiving_button").click(function() {
            $('#finish_receiving_form').submit();
        });

        $("#cancel_receiving_button").click(function() {
            if (confirm('<?= lang(ucfirst($controller_name) . '.confirm_cancel_receiving') ?>')) {
                $('#finish_receiving_form').attr('action', '<?= esc("$controller_name/cancelReceiving") ?>');
                $('#finish_receiving_form').submit();
            }
        });

        $("#cart_contents input").keypress(function(event) {
            if (event.which == 13) {
                $(this).parents("tr").prevAll("form:first").submit();
            }
        });

        table_support.handle_submit = function(resource, response, stay_open) {
            if (response.success) {
                if (resource.match(/suppliers$/)) {
                    $("#supplier").val(response.id);
                    $("#select_supplier_form").submit();
                } else {
                    $("#item").val(response.id);
                    if (stay_open) {
                        $("#add_item_form").ajaxSubmit();
                    } else {
                        $("#add_item_form").submit();
                    }
                }
            }
        }

        $('[name="price"],[name="quantity"],[name="qty_carton"],[name="qty_piece"],[name="receiving_quantity"],[name="discount"],[name="description"],[name="serialnumber"]').change(function() {
            $(this).parents("tr").prevAll("form:first").submit()
        });

        $('[name="discount_toggle"]').change(function() {
            var input = $("<input>").attr("type", "hidden").attr("name", "discount_type").val(($(this).prop('checked')) ? 1 : 0);
            $('#cart_' + $(this).attr('data-line')).append($(input));
            $('#cart_' + $(this).attr('data-line')).submit();
        });

    });
</script>

<?= view('partial/footer') ?>
