<?php
/**
 * @var array $stock_locations
 * @var array $days_ahead_options
 */
?>

<?= view('partial/header') ?>
<link rel="stylesheet" href="<?= base_url('css/reports-pages.css') ?>" media="all">

<script type="text/javascript">
    dialog_support.init("a.modal-dlg");
</script>

<div class="col-xs-12 reports-page">
<div class="reports-input-card">
<div id="page_title"><?= lang('Reports.report_input') ?></div>

<?php
if (isset($error)) {
    echo '<div class="alert alert-dismissible alert-danger">' . esc($error) . '</div>';
}
?>

<?= form_open('#', ['id' => 'item_form', 'enctype' => 'multipart/form-data', 'class' => 'form-horizontal']) ?>

    <div class="form-group form-group-sm">
        <?= form_label(lang('Reports.stock_location'), 'reports_stock_location_label', ['class' => 'required control-label col-xs-2']) ?>
        <div id="report_stock_location" class="col-xs-3">
            <?= form_dropdown('stock_location', $stock_locations, 'all', 'id="location_id" class="form-control"') ?>
        </div>
    </div>

    <div class="form-group form-group-sm">
        <?= form_label(lang('Items.expired_near_expire_items'), 'reports_days_ahead_label', ['class' => 'required control-label col-xs-2']) ?>
        <div id="report_days_ahead" class="col-xs-3">
            <?= form_dropdown('days_ahead', $days_ahead_options, '30', 'id="days_ahead" class="form-control"') ?>
        </div>
    </div>

    <div class="form-group form-group-sm">
        <div class="col-xs-offset-2 col-xs-10">
            <label class="checkbox-inline">
                <?= form_checkbox('include_batches', '1', false, 'id="include_batches"') ?>
                <?= lang('Reports.include_batch_expiry') ?>
            </label>
        </div>
    </div>

    <?php
    echo form_button([
        'name'    => 'generate_report',
        'id'      => 'generate_report',
        'content' => lang('Common.submit'),
        'class'   => 'btn btn-primary btn-sm'
    ]) ?>

<?= form_close() ?>
</div>
</div>

<?= view('partial/footer') ?>

<script type="text/javascript">
    $(document).ready(function() {
        $("#generate_report").click(function() {
            var base = [window.location, $("#location_id").val(), $("#days_ahead").val()].join("/");
            var batches = $("#include_batches").is(":checked") ? "/1" : "/0";
            window.location = base + batches;
        });
    });
</script>
