<?php
/**
 * @var string $supplier_name
 * @var array $credit_receivings
 * @var array $config
 */
?>

<?= view('partial/header') ?>

<div id="title_bar" class="btn-toolbar">
    <?= anchor('suppliers', '<span class="glyphicon glyphicon-arrow-left">&nbsp;</span>' . lang('Common.back'), ['class' => 'btn btn-info btn-sm']) ?>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Suppliers.total_credit_purchase') ?> - <?= esc($supplier_name) ?></h3>
    </div>
    <div class="panel-body">
        <?php if (empty($credit_receivings)): ?>
            <p><?= lang('Suppliers.no_credit_receivings') ?></p>
        <?php else: ?>
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th><?= lang('Common.id') ?></th>
                        <th><?= lang('Receivings.date') ?></th>
                        <th><?= lang('Sales.amount_due') ?></th>
                        <th><?= lang('Suppliers.total_credit_paid') ?></th>
                        <th><?= lang('Suppliers.credit_balance') ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($credit_receivings as $recv): ?>
                        <tr>
                            <td><?= esc($recv->receiving_id) ?></td>
                            <td><?= to_datetime(strtotime($recv->receiving_time)) ?></td>
                            <td><?= to_currency($recv->total) ?></td>
                            <td><?= to_currency($recv->paid) ?></td>
                            <td><?= to_currency($recv->balance) ?></td>
                            <td><?= anchor('receivings/receipt/' . $recv->receiving_id, '<span class="glyphicon glyphicon-usd"></span>', ['target' => '_blank', 'title' => lang('Receivings.receipt_number')]) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?= view('partial/footer') ?>
