<?php
/**
 * @var string $controller_name
 * @var array $stock_locations
 */
?>

<?= view('partial/header') ?>
<link rel="stylesheet" href="<?= base_url('css/transfer-pages.css') ?>" media="all">

<div class="col-xs-12 transfer-page">
<?= form_open("$controller_name/add", ['id' => 'transfer_form', 'class' => 'form-horizontal']) ?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Transfers.transfer') ?></h3>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <label class="col-xs-3 control-label"><?= lang('Transfers.from_branch') ?> *</label>
            <div class="col-xs-4">
                <?= form_dropdown('from_location_id', $stock_locations, '', ['id' => 'from_location_id', 'class' => 'form-control input-sm required']) ?>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-3 control-label"><?= lang('Transfers.to_branch') ?> *</label>
            <div class="col-xs-4">
                <?= form_dropdown('to_location_id', $stock_locations, '', ['id' => 'to_location_id', 'class' => 'form-control input-sm required']) ?>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-3 control-label"><?= lang('Transfers.item') ?></label>
            <div class="col-xs-4">
                <?= form_input(['name' => 'item_search', 'id' => 'item_search', 'class' => 'form-control input-sm', 'placeholder' => lang('Transfers.add_item')]) ?>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-3 control-label"><?= lang('Transfers.comment') ?></label>
            <div class="col-xs-4">
                <?= form_textarea(['name' => 'comment', 'id' => 'comment', 'class' => 'form-control input-sm', 'rows' => 2]) ?>
            </div>
        </div>
    </div>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Transfers.transfer_items') ?></h3>
    </div>
    <div class="panel-body">
        <table class="table table-striped table-bordered" id="transfer_items_table">
            <thead>
                <tr>
                    <th><?= lang('Transfers.item') ?></th>
                    <th><?= lang('Transfers.available') ?></th>
                    <th><?= lang('Transfers.quantity') ?></th>
                    <th></th>
                </tr>
            </thead>
            <tbody id="transfer_items_body">
            </tbody>
        </table>
        <button type="submit" id="submit_transfer" class="btn btn-primary btn-sm" disabled>
            <?= lang('Transfers.submit') ?>
        </button>
        <?= anchor($controller_name, lang('Common.cancel'), ['class' => 'btn btn-default btn-sm']) ?>
    </div>
</div>
<?= form_close() ?>
</div>

<script type="text/javascript">
$(document).ready(function() {
    var transferItems = [];
    var stockLocations = <?= json_encode($stock_locations) ?>;

    $('#item_search').autocomplete({
        source: function(req, resp) {
            var fromId = $('#from_location_id').val();
            if (!fromId) {
                resp([]);
                return;
            }
            $.getJSON('<?= base_url("$controller_name/itemSearch") ?>?term=' + encodeURIComponent(req.term) + '&from_location_id=' + fromId, resp);
        },
        minLength: 2,
        select: function(e, ui) {
            var item = ui.item;
            var exists = transferItems.find(function(x) { return x.item_id == item.value; });
            if (exists) {
                return;
            }
            transferItems.push({
                item_id: item.value,
                label: item.label,
                available: item.available || 0,
                quantity: 1
            });
            renderItems();
            $('#item_search').val('');
            return false;
        }
    });

    function renderItems() {
        var tbody = $('#transfer_items_body');
        tbody.empty();
        transferItems.forEach(function(item, idx) {
            var tr = $('<tr></tr>');
            tr.append($('<td></td>').text(item.label));
            tr.append($('<td></td>').text(parseFloat(item.available).toFixed(<?= quantity_decimals() ?>)));
            var qtyInput = $('<input type="number" name="quantity[]" class="form-control input-sm" min="0.001" max="' + item.available + '" step="0.001" value="' + item.quantity + '">');
            qtyInput.data('idx', idx);
            qtyInput.on('change', function() {
                transferItems[$(this).data('idx')].quantity = parseFloat($(this).val()) || 0;
            });
            tr.append($('<td></td>').append(qtyInput));
            var rmBtn = $('<button type="button" class="btn btn-danger btn-xs">×</button>');
            rmBtn.on('click', function() {
                transferItems.splice(idx, 1);
                renderItems();
            });
            tr.append($('<td></td>').append(rmBtn).append($('<input type="hidden" name="item_id[]">').val(item.item_id)));
            tbody.append(tr);
        });
        $('#submit_transfer').prop('disabled', transferItems.length === 0);
    }

    $('#transfer_form').on('submit', function(e) {
        var fromId = $('#from_location_id').val();
        var toId = $('#to_location_id').val();
        if (fromId === toId) {
            e.preventDefault();
            alert('<?= lang('Transfers.same_branch') ?>');
            return false;
        }
        if (transferItems.length === 0) {
            e.preventDefault();
            alert('<?= lang('Transfers.no_items') ?>');
            return false;
        }
    });
});
</script>

<?= view('partial/footer') ?>
