<?php
/**
 * Transfer form content for modal (no header/footer).
 * @var string $controller_name
 * @var array $stock_locations
 */
?>
<link rel="stylesheet" href="<?= base_url('css/transfer-pages.css') ?>" media="all">

<div class="transfer-form-content">
<div id="required_fields_message"><?= lang('Common.fields_required_message') ?></div>
<ul id="error_message_box" class="error_message_box"></ul>

<?= form_open("$controller_name/add", ['id' => 'transfer_form', 'class' => 'form-horizontal']) ?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Transfers.transfer') ?></h3>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <label class="col-xs-3 control-label"><?= lang('Transfers.from_branch') ?> *</label>
            <div class="col-xs-4">
                <?= form_dropdown('from_location_id', $stock_locations, '', ['id' => 'from_location_id', 'class' => 'form-control input-sm required']) ?>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-3 control-label"><?= lang('Transfers.to_branch') ?> *</label>
            <div class="col-xs-4">
                <?= form_dropdown('to_location_id', $stock_locations, '', ['id' => 'to_location_id', 'class' => 'form-control input-sm required']) ?>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-3 control-label"><?= lang('Transfers.item') ?></label>
            <div class="col-xs-4">
                <?= form_input(['name' => 'item_search', 'id' => 'item_search', 'class' => 'form-control input-sm', 'placeholder' => lang('Transfers.add_item')]) ?>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-3 control-label"><?= lang('Transfers.comment') ?></label>
            <div class="col-xs-4">
                <?= form_textarea(['name' => 'comment', 'id' => 'comment', 'class' => 'form-control input-sm', 'rows' => 2]) ?>
            </div>
        </div>
    </div>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= lang('Transfers.transfer_items') ?></h3>
    </div>
    <div class="panel-body">
        <table class="table table-striped table-bordered" id="transfer_items_table">
            <thead>
                <tr>
                    <th><?= lang('Transfers.item') ?></th>
                    <th><?= lang('Transfers.available') ?> &ndash; <?= lang('Sales.carton_qty') ?></th>
                    <th><?= lang('Transfers.available') ?> &ndash; <?= lang('Sales.pieces_qty') ?></th>
                    <th><?= lang('Transfers.quantity') ?> &ndash; <?= lang('Sales.carton_qty') ?></th>
                    <th><?= lang('Transfers.quantity') ?> &ndash; <?= lang('Sales.pieces_qty') ?></th>
                    <th></th>
                </tr>
            </thead>
            <tbody id="transfer_items_body">
                <tr id="transfer_items_empty" class="text-muted">
                    <td colspan="6"><em><?= lang('Transfers.no_items_hint') ?></em></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<?= form_close() ?>
</div>

<script type="text/javascript">
$(document).ready(function() {
    var transferItems = [];
    var stockLocations = <?= json_encode($stock_locations) ?>;

    $('#item_search').autocomplete({
        source: function(req, resp) {
            var fromId = $('#from_location_id').val();
            if (!fromId) {
                resp([]);
                return;
            }
            $.getJSON('<?= base_url("$controller_name/itemSearch") ?>?term=' + encodeURIComponent(req.term) + '&from_location_id=' + fromId, resp);
        },
        minLength: 2,
        appendTo: '.modal-content',
        select: function(e, ui) {
            var it = ui.item;
            var exists = transferItems.find(function(x) { return x.item_id == it.value; });
            if (exists) {
                return;
            }
            var qtyPer = parseFloat(it.qty_per) || 1;
            var hasBulk = it.has_bulk && qtyPer > 1;
            transferItems.push({
                item_id: it.value,
                label: it.label,
                available: it.available || 0,
                available_carton: it.available_carton ?? 0,
                available_pieces: it.available_pieces ?? it.available,
                qty_per: qtyPer,
                has_bulk: hasBulk,
                quantity: hasBulk ? qtyPer : 1,
                qty_carton: hasBulk ? 1 : 0,
                qty_piece: hasBulk ? 0 : 1
            });
            renderItems();
            $('#item_search').val('');
            return false;
        }
    });

    function renderItems() {
        var tbody = $('#transfer_items_body');
        $('#transfer_items_empty').remove();
        tbody.empty();
        if (transferItems.length === 0) {
            tbody.append($('<tr id="transfer_items_empty" class="text-muted"><td colspan="6"><em><?= lang('Transfers.no_items_hint') ?></em></td></tr>'));
        }
        transferItems.forEach(function(item, idx) {
            var tr = $('<tr></tr>');
            tr.append($('<td></td>').text(item.label));
            var qtyPer = parseFloat(item.qty_per) || 1;
            var hasBulk = item.has_bulk && qtyPer > 1;
            var availCarton = hasBulk ? (item.available_carton ?? Math.floor(item.available / qtyPer)) : 0;
            var availPieces = hasBulk ? (item.available_pieces ?? (item.available - availCarton * qtyPer)) : item.available;
            tr.append($('<td></td>').text(hasBulk ? parseFloat(availCarton).toFixed(<?= quantity_decimals() ?>) : '&ndash;'));
            tr.append($('<td></td>').text(parseFloat(availPieces).toFixed(<?= quantity_decimals() ?>)));
            var cartonQty = item.qty_carton ?? (hasBulk ? Math.floor((item.quantity || 0) / qtyPer) : 0);
            var pieceQty = item.qty_piece ?? (hasBulk ? ((item.quantity || 0) - cartonQty * qtyPer) : (item.quantity || 0));
            var cartonInput = $('<input type="number" name="qty_carton[]" class="form-control input-sm text-center" min="0" max="' + (hasBulk ? availCarton : 0) + '" step="1" value="' + cartonQty + '" style="max-width:65px">');
            var pieceInput = $('<input type="number" name="qty_piece[]" class="form-control input-sm text-center" min="0" max="' + availPieces + '" step="' + (hasBulk ? '1' : '0.001') + '" value="' + pieceQty + '" style="max-width:65px">');
            cartonInput.data('idx', idx);
            pieceInput.data('idx', idx);
            cartonInput.on('change', function() {
                var i = transferItems[$(this).data('idx')];
                i.qty_carton = parseFloat($(this).val()) || 0;
                i.quantity = i.qty_carton * (parseFloat(i.qty_per) || 1) + (parseFloat(i.qty_piece) || 0);
            });
            pieceInput.on('change', function() {
                var i = transferItems[$(this).data('idx')];
                i.qty_piece = parseFloat($(this).val()) || 0;
                i.qty_carton = i.qty_carton ?? 0;
                i.quantity = (parseFloat(i.qty_carton) || 0) * (parseFloat(i.qty_per) || 1) + i.qty_piece;
            });
            tr.append($('<td></td>').append(hasBulk ? cartonInput : $('<span>').html('&ndash;')));
            var pieceTd = $('<td></td>').append(pieceInput);
            pieceTd.append($('<input type="hidden" name="item_id[]">').attr('value', item.item_id));
            pieceTd.append($('<input type="hidden" name="qty_per[]">').attr('value', qtyPer));
            tr.append(pieceTd);
            var rmBtn = $('<button type="button" class="btn btn-danger btn-xs">×</button>');
            rmBtn.on('click', function() {
                transferItems.splice(idx, 1);
                renderItems();
            });
            tr.append($('<td></td>').append(rmBtn));
            tbody.append(tr);
        });
    }

    $('#transfer_form').on('submit', function(e) {
        var fromId = $('#from_location_id').val();
        var toId = $('#to_location_id').val();
        if (fromId === toId) {
            e.preventDefault();
            alert('<?= lang('Transfers.same_branch') ?>');
            return false;
        }
        var itemCount = $('#transfer_form input[name="item_id[]"]').length;
        if (itemCount === 0) {
            e.preventDefault();
            alert('<?= lang('Transfers.no_items') ?>');
            return false;
        }
        e.preventDefault();
        this.submit();
    });
});
</script>
