<?php
/**
 * @var string $controller_name
 * @var array $transfers
 * @var array $stock_locations
 */
?>

<?= view('partial/header') ?>
<link rel="stylesheet" href="<?= base_url('css/manage-pages.css') ?>" media="all">

<script type="text/javascript">
    $(document).ready(function() {
        dialog_support.init("button.modal-dlg");
    });
</script>

<div class="col-xs-12">
<div class="manage-page manage-page--transfers">
    <div class="manage-page-header">
        <h2 class="manage-page-title"><?= lang('Transfers.transfers') ?></h2>
        <div class="manage-page-actions">
            <button type="button" class="btn btn-info btn-sm modal-dlg modal-dlg-wide" data-btn-submit="<?= lang('Transfers.submit') ?>" data-href="<?= esc(base_url("$controller_name/add")) ?>" title="<?= lang('Transfers.transfer') ?>">
                <span class="glyphicon glyphicon-plus"></span> <?= lang('Transfers.transfer') ?>
            </button>
        </div>
    </div>

    <?php if (!empty($success)) : ?>
        <div class="alert alert-success"><?= esc($success) ?></div>
    <?php endif; ?>
    <?php if (!empty($error)) : ?>
        <div class="alert alert-danger"><?= esc($error) ?></div>
    <?php endif; ?>

    <div id="title_bar" class="print_hide" style="display:none;"></div>

    <div class="manage-table-card">
        <?php if (empty($transfers)) : ?>
            <div style="padding: 2rem; text-align: center; color: #64748b;">No transfers yet.</div>
        <?php else : ?>
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th><?= lang('Common.id') ?></th>
                        <th><?= lang('Transfers.from_branch') ?></th>
                        <th><?= lang('Transfers.to_branch') ?></th>
                        <th><?= lang('Reports.date') ?></th>
                        <th><?= lang('Reports.employee') ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($transfers as $t) : ?>
                        <tr>
                            <td><?= esc($t->transfer_id) ?></td>
                            <td><?= esc($t->from_location_name ?? '') ?></td>
                            <td><?= esc($t->to_location_name ?? '') ?></td>
                            <td><?= date($config['dateformat'] ?? 'Y-m-d', strtotime($t->transfer_time ?? 'now')) ?></td>
                            <td><?= esc($t->employee_name ?? '') ?></td>
                            <td><?= anchor("$controller_name/view/$t->transfer_id", lang('Common.det')) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>
</div>

<?= view('partial/footer') ?>
