<?php
/**
 * @var string $controller_name
 * @var object $transfer
 */
$config = config('OSPOS')->settings ?? [];
$transaction_time = date($config['dateformat'] ?? 'Y-m-d') . ' ' . date($config['timeformat'] ?? 'H:i:s', strtotime($transfer->transfer_time ?? 'now'));
?>

<?= view('partial/header') ?>
<link rel="stylesheet" href="<?= base_url('css/transfer-pages.css') ?>" media="all">

<?= view('partial/print_receipt', ['print_after_sale' => false, 'selected_printer' => 'receipt_printer', 'redirect_url' => 'transfers']) ?>

<div class="print_hide" id="control_buttons" style="text-align: right; margin-bottom: 1rem;">
    <a href="javascript:printdoc();">
        <div class="btn btn-info btn-sm" id="show_print_button"><?= '<span class="glyphicon glyphicon-print">&nbsp;</span>' . lang('Common.print') ?></div>
    </a>
    <?= anchor($controller_name, '<span class="glyphicon glyphicon-list"></span> ' . lang('Transfers.transfers'), ['class' => 'btn btn-info btn-sm']) ?>
    <?= anchor($controller_name . '/add', '<span class="glyphicon glyphicon-plus"></span> ' . lang('Transfers.transfer'), ['class' => 'btn btn-info btn-sm']) ?>
</div>

<div id="receipt_wrapper">
    <div id="receipt_header">
        <?php if (!empty($config['company_logo'])) { ?>
            <div id="company_name">
                <img id="image" src="<?= base_url('uploads/' . esc($config['company_logo'], 'url')) ?>" alt="company_logo">
            </div>
        <?php } ?>

        <?php if ($config['receipt_show_company_name'] ?? false) { ?>
            <div id="company_name"><?= esc($config['company']) ?></div>
        <?php } ?>

        <div id="company_address"><?= nl2br(esc($config['address'] ?? '')) ?></div>
        <div id="company_phone"><?= esc($config['phone'] ?? '') ?></div>
        <div id="sale_receipt"><?= lang('Transfers.transfer') ?></div>
        <div id="sale_time"><?= esc($transaction_time) ?></div>
    </div>

    <div id="receipt_general_info">
        <div id="sale_id"><?= lang('Reports.transfer_id') . ': ' . esc($transfer->transfer_id) ?></div>
        <div id="customer"><?= lang('Transfers.from_branch') . ': ' . esc($transfer->from_location_name ?? '') ?></div>
        <div id="reference"><?= lang('Transfers.to_branch') . ': ' . esc($transfer->to_location_name ?? '') ?></div>
        <div id="employee"><?= lang('Employees.employee') . ': ' . esc($transfer->employee_name ?? '') ?></div>
        <?php if (!empty($transfer->comment)) : ?>
            <div id="comment"><?= lang('Transfers.comment') . ': ' . esc($transfer->comment) ?></div>
        <?php endif; ?>
    </div>

    <table id="receipt_items">
        <tr>
            <th style="width: 60%;"><?= lang('Transfers.item') ?></th>
            <th style="width: 20%;"><?= lang('Sales.carton_qty') ?></th>
            <th style="width: 20%; text-align: right;"><?= lang('Sales.pieces_qty') ?></th>
        </tr>

        <?php foreach ($transfer->items ?? [] as $item) :
            $qp = quantity_to_carton_pieces((float) ($item->quantity ?? 0), $item);
            ?>
            <tr>
                <td><?= esc(trim($item->name ?? '') ?: ($item->item_number ?? '-')) ?></td>
                <td><?= $qp['has_bulk'] ? to_quantity_decimals($qp['carton']) : '&ndash;' ?></td>
                <td><div class="total-value"><?= to_quantity_decimals($qp['pieces']) ?></div></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <div id="barcode">
        <?= esc($transfer->transfer_id) ?>
    </div>
</div>

<?= view('partial/footer') ?>
