#!/usr/bin/env php
<?php
/**
 * Prepare OSPOS GTS for deployment to cPanel or production.
 * Cleans development artifacts and optionally creates a deploy package.
 *
 * Usage: php prepare_deploy.php [--clean-only]
 *   --clean-only  Only clean, do not show deploy checklist
 */

$cleanOnly = in_array('--clean-only', $argv ?? [], true);
$baseDir = __DIR__;

// Clean writable/debugbar
$debugbarDir = $baseDir . '/writable/debugbar';
if (is_dir($debugbarDir)) {
    $files = glob($debugbarDir . '/*');
    $count = 0;
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
            $count++;
        }
    }
    echo "Cleaned {$count} debug bar files from writable/debugbar/\n";
} else {
    echo "writable/debugbar/ not found or empty.\n";
}

// Clean writable/cache (optional - can slow first request)
$cacheDir = $baseDir . '/writable/cache';
if (is_dir($cacheDir)) {
    $count = 0;
    foreach (glob($cacheDir . '/*') as $f) {
        if (is_file($f) && basename($f) !== 'index.html') {
            unlink($f);
            $count++;
        }
    }
    if ($count > 0) {
        echo "Cleaned {$count} cache files.\n";
    }
}

if (!$cleanOnly) {
    echo "\n--- Pre-Deploy Checklist ---\n";
    echo "1. Copy .env.production to .env and set:\n";
    echo "   CI_ENVIRONMENT = production\n";
    echo "   CI_DEBUG = false\n";
    echo "   app.baseURL = your full URL\n";
    echo "   database.* credentials\n";
    echo "2. Generate encryption key: php spark key:generate\n";
    echo "3. Set writable/ permissions: chmod -R 755 writable\n";
    echo "4. Set document root to public/ folder\n";
    echo "5. Remove after use: public/health_check.php, public/generate_key.php\n";
    echo "6. Optional: composer install --no-dev --optimize-autoloader\n";
    echo "\nTo create a production ZIP: php build_package.php --optimize\n";
    echo "See DEPLOYMENT.md and CPANEL_SETUP.md for full instructions.\n";
}
